<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

use App\Model\Product;
use App\Model\Order\OrderProduct;

/**
 * SELECT produse_id, nume FROM `produse` WHERE `produse_id` IN (310,318,356,390,416,428,492,530,540,552,558,606,618,642,778,829,833,837,843,851,884,885,939,955,973,1053,1087,1117,1133,1161)

 */
class syncStock extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'stock:sync';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync products stock with database';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->output->write($this->description . PHP_EOL);

        // check if update is needed.
        $config = \Illuminate\Support\Facades\DB::connection('stocks')->table('config')->orderByDesc('id')->get()->first();

        $last_update = $config->value;
//        $config->value = now(); // @temp

        if (now()->diffInDays($config->value) <= 1) {
            DB::transaction(function () use ($last_update) {
                $ordered_products = OrderProduct::select('product_id', DB::raw('SUM(qty) as sum'))
                    ->without('product')
                    ->whereHas('order', function ($q) {
                        $q->where('status', 'new');
                    })->groupBy('product_id')
                    ->get()->pluck('sum', 'product_id');

                $product_stocks = DB::connection('stocks')
                    ->table('produse')
                    ->where('last_edit', '>=', $last_update)
                    ->get();

                foreach ($product_stocks as $product_stock) {
                    $product = Product::where(['code' => $product_stock->produse_id])->first();

                    if (!$product) {
                        $this->output->write("Product {$product_stock->produse_id} not found"  . PHP_EOL);
                        continue;
                    }

                    Product::withoutEvents(function () use ($product, $product_stock, $ordered_products) {
                        // update stock
                        $product->stock = $product_stock->quantity;

                        // subtract qty from stock from opened orders!
                        if (isset($ordered_products[$product->id])) {
                            $product->stock -= $ordered_products[$product->id];;
                        }

                        // make sure there is no negative stock.
                        if ($product->stock < 0) {
                            $product->stock = 0;
                        }

                        if ($product->getOriginal('stock') != $product->stock) {
                            $product->stock_updated_at = now();
                        }

                        // @todo trigger notifications
                        $product->save();
                    });
                }
            });
        }

        $this->output->write("Total time(s): " . (microtime(true) - LARAVEL_START));
        $this->output->write(PHP_EOL);
    }
}
