<?php

namespace App\Helpers;

class CartItem
{

//    public $product_id;
    public $offer_id;
    public $qty;
    public $final_qty;
    public $product;

    public function __construct($item)
    {
        foreach ($item as $key => $value) {
            $this->$key = $value;
        }

        // auto select qty based on stock.
        $this->final_qty = $this->isEnoughStock() ? $this->qty : $this->product->stock;
    }

    public function toArray()
    {
        return get_object_vars($this);
    }

    public function isEnoughStock()
    {
        if ($this->product->validate_stock && $this->product->stock < $this->qty) {
            return false;
        }
        return true;
    }

    public function getQty()
    {
        return $this->final_qty;
    }

    public function getRequestedQty()
    {
        return $this->qty;
    }

    public function getTotalPrice() {
        return $this->product->getPrice() * $this->getQty();
    }

}
