<?php

namespace App\Helpers;

use App\Model\Product;

class UserProducts {

//    public static $model = Product::class;
    public static $model_with = ['photo'];
    public static $count = null;
    public static $instance;


    public static function instance()
    {
        // return instance if we haz it.
        if (static::$instance) {
            return static::$instance;
        }

        // if logged in we get from db,
        if (auth()->check()) {
           static::$instance = new static();
        } else {
            // if we are not logged in, we wanna simply forward everything to RecentItems class.
            static::$instance =  new FavoriteProducts;
        }

        return static::$instance;
    }

    public function all() {
        return auth()->user()->products;
    }

    public function count() {
        if (self::$count !== null) {
           return self::$count;
        }
        return  self::$count = auth()->user()->products()->count();
    }

    public function contains($product)
    {
        return $this->all()->contains($product);
    }


    public function allWithDb() {
        return $this->all();
    }

    public function toggle($item)
    {
        if ($this->all()->contains($item)) {
            auth()->user()->products()->detach($item);
            return false;
        }
        auth()->user()->products()->attach($item);
        return true;
    }
//
//    public function add($item)
//    {
//        $item = is_object($item) ? $item->id : $item;
//        parent::add($item);
//    }

}
