<?php

namespace App\Http\Controllers\Admin;

use App\Model\Ad;
use Illuminate\Http\Request;

class AdController extends BaseController
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $ads = Ad::all();
        return view('admin.ad.index', compact('ads'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Ad $ad)
    {
        return view('admin.ad.edit', compact('ad'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, Ad $ad)
    {
        return $this->update($request, $ad);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Model\Ad  $ad
     * @return \Illuminate\Http\Response
     */
    public function show(Ad $ad)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Model\Ad  $ad
     * @return \Illuminate\Http\Response
     */
    public function edit(Ad $ad)
    {
        return view('admin.ad.edit', compact('ad'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Model\Ad  $ad
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Ad $ad)
    {
        $ad->fill($request->except(['photo']));
        if ($request->hasFile('photo')) {
            $ad->photo = basename($request->photo->storeAs('featuring', implode('.', [$ad->slug, $request->photo->getClientOriginalExtension()])));
        }

        $ad->save();
        return redirect(route('admin.ads.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Model\Ad  $ad
     * @return \Illuminate\Http\Response
     */
    public function destroy(Ad $ad)
    {
        $ad->delete();
        return redirect(route('admin.ads.index'));
    }

    public function priority(Request $request)
    {

        foreach ($request->get('priority') as $item) {
            $product = Ad::find($item['id']);
            $product->priority = $item['priority'];
            $product->save();
        }
    }

}
