<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\StorePhoto;
use App\Model\Brand;
use App\Model\Brand\BrandPhoto;
use Illuminate\Http\Request;
use File;
use StringOperation;

class BrandController extends BaseController
{
    use Photos;


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $brands = Brand::all();
        return view('admin.brand.index', compact('brands'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Brand $brand)
    {
        return view('admin.brand.edit', compact('brand'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, Brand $brand)
    {
        return $this->update($request, $brand);
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Model\Brand $brand
     * @return \Illuminate\Http\Response
     */
    public function show(Brand $brand)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Model\Brand $brand
     * @return \Illuminate\Http\Response
     */
    public function edit(Brand $brand)
    {
        $item = &$brand;

        return view('admin.brand.edit', compact('brand', 'item'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param \App\Model\Brand $brand
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Brand $brand)
    {
        $brand->fill($request->except(['logo']));
        if ($request->hasFile('logo')) {
            $brand->logo = basename($request->logo->storeAs('logo', implode('.', [$brand->slug, $request->logo->getClientOriginalExtension()])));
        }

//        if ($request->hasFile('photo')) {
//            $brand->photo = basename($request->photo->storeAs('brand_photos', implode('.', [$brand->slug, $request->photo->getClientOriginalExtension()])));
//        }

        $brand->save();
        return redirect()->route('admin.brands.edit', $brand);

//        return redirect(route('admin.brands.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Model\Brand $brand
     * @return \Illuminate\Http\Response
     */
    public function destroy(Brand $brand)
    {
        $brand->delete();
        return redirect(route('admin.brands.index'));
    }

    public function photo(Brand $brand, StorePhoto $request)
    {
        return $this->process($brand, $request, BrandPhoto::class);
    }

    public function photos(Brand $brand)
    {
        return $this->list($brand);
    }

}
