<?php

namespace App\Http\Controllers\Admin;


use Illuminate\Http\Request;
use App\Http\Requests\StoreGallery;
use Utils;
use Validator;
use Illuminate\Support\Facades\DB;

use App\Model\Gallery;
use App\Model\Gallery\GalleryPhoto;

use App\Http\Requests\StorePhoto;

class GalleryController extends BaseController
{

    use Photos;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $galleries = (new Gallery)->newQuery();

        // do we have a search here?
        if ($q = $request->get('q')) {
            $galleries->search($q);
        }

        if ($code = $request->get('code')) {
            $galleries->where('code', 'like', '%' . $code . '%');
        }

        $galleries->with('photo')
            // use array_filter cos for example, if camapign_id= is passed then wrong filtering will occur
            ->where(array_filter($request->except([
                'q',
                'code',
                'page',
                'category_id',
                'order_by',
                'order_direction',
                'sortable',
            ])));


        $galleries = $galleries
//            ->orderBy($request->get('order_by') ?: 'id', $request->get('order_direction') ?: 'desc')
            ->paginate(config('pagination.admin.items_per_page'))
            ->appends($request->except('page'));


        return view('admin.gallery.index', compact('galleries'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Gallery $gallery)
    {
        return $this->edit($gallery);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreGallery $request, Gallery $gallery)
    {
        return $this->update($request, $gallery);
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Model\Gallery $gallery
     * @return \Illuminate\Http\Response
     */
    public function show(Gallery $gallery)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Model\Gallery $gallery
     * @return \Illuminate\Http\Response
     */
    public function edit(Gallery $gallery)
    {
        $item = &$gallery;

        return view('admin.gallery.edit', compact('gallery', 'item'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param \App\Model\Gallery $gallery
     * @return \Illuminate\Http\Response
     */
    public function update(StoreGallery $request, Gallery $gallery)
    {
        try {
            DB::beginTransaction();

            $gallery->fill($request->except('files'))
                ->save();


            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            /* Transaction failed. */
            dd($e->getMessage());
        }

        return redirect(route('admin.galleries.edit', $gallery));
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Model\Gallery $gallery
     * @return \Illuminate\Http\Response
     */
    public function destroy(Gallery $gallery)
    {
        $gallery->delete();

        return back();
    }

    public function photo(Gallery $gallery, StorePhoto $request)
    {
        return $this->process($gallery, $request, GalleryPhoto::class);
    }

    public function photos(Gallery $gallery)
    {
        return $this->list($gallery);
    }

    public function priority(Request $request)
    {
        $items = $request->get('priority');

        foreach ($items as $item) {
            $gallery = Gallery::find($item['id']);
            $gallery->priority = $item['priority'];
            if ($gallery->id == $request->get('current_id')) {
                $gallery->is_manually_prioritized = 1;
            } elseif ($item['priority'] >= config('featured.max_manually_prioritized')) {
                $gallery->is_manually_prioritized = 0;
            }
            $gallery->save();
        }
    }

}
