<?php

namespace App\Http\Controllers\Admin;

use App\Model\Portfolio;
use App\Model\Portfolio\PortfolioPhoto;
use Illuminate\Http\Request;
use Utils;
use Validator;
use App\Http\Requests\StorePhoto;

class PortfolioController extends BaseController {

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
        $portfolios = new Portfolio;

        // do we have a search here?
        if ($q = $request->get('q')) {
            $portfolios = $portfolios->search($q);
        }


        $portfolios = $portfolios->with('photo')
                        ->recent()
                        ->where($request->except(['q', 'page']))
                        ->paginate(config('pagination.admin.items_per_page'))->appends($request->except('page'));

        return view('admin.portfolio.index', compact('portfolios'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Portfolio $portfolio) {
        return $this->edit($portfolio);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StorePhoto $request, Portfolio $portfolio) {
        return $this->update($request, $portfolio);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Model\Portfolio  $portfolio
     * @return \Illuminate\Http\Response
     */
    public function edit(Portfolio $portfolio) {
   


        return view('admin.portfolio.edit', compact('portfolio'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Model\Portfolio  $portfolio
     * @return \Illuminate\Http\Response
     */
    public function update(StorePhoto $request, Portfolio $portfolio) {
        $portfolio->fill($request->except('files'))->save();


        return redirect(route('admin.portfolios.edit', $portfolio));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Model\Portfolio  $portfolio
     * @return \Illuminate\Http\Response
     */
    public function destroy(Portfolio $portfolio) {
        $portfolio->delete();

        return back();
    }

   

    public function photo(Portfolio $portfolio, StorePhoto $request) {
        // we got a re-arange of photos.
        if ($list = $request->get('priority')) {
            foreach ($list as $key => $item) {
                // or $user->photos()->whereId($item['id'])->get()->first();
                $photo = $portfolio->photos()->find($item['id']);
                $photo->priority = $item['priority'];
                $photo->save();
            }
            return;
        }

        // delete photo
        if ($request->method() === 'DELETE') {
            $photo = $portfolio->photos()->find($request->get('id'));
            if ($photo) {
                $photo->delete();
            }
            return;
        }

        // upload the photo.
        $photo = new PortfolioPhoto();
        $photo->portfolio_id = $portfolio->id;

        // go ask for a upload.
        $photo->upload($request->file('photo'));

        // save photo to the portfolio
        $portfolio->photos()->save($photo);

        // return the view again
        return view('admin.portfolio.photo.item', compact('portfolio', 'photo'));
    }



}
