<?php

namespace App\Http\Controllers\Admin;

use App\Model\City;
use App\Model\Text;
use App\Model\Category;
use App\Model\Brand;
use App\Model\Campaign;
use App\Model\Text\TextPhoto;
use Illuminate\Http\Request;
use App\Http\Requests\StoreText;
use Str;
use Utils;
use Validator;
use App\Http\Requests\StorePhoto;

class TextController extends BaseController
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // group by cities?
        $texts = Text::all();

        return view('admin.text.index', compact('texts'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Text $text, Request $request)
    {
        return $this->edit($text);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreText $request, Text $text)
    {
        return $this->update($request, $text);
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Model\Text $text
     * @return \Illuminate\Http\Response
     */
    public function show(Text $text)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Model\Text $text
     * @return \Illuminate\Http\Response
     */
    public function edit(Text $text)
    {
        return view('admin.text.edit', compact('text'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param \App\Model\Text $text
     * @return \Illuminate\Http\Response
     */
    public function update(StoreText $request, Text $text)
    {
        $text
            ->fill($request->all())
            ->save();

        return redirect(route('admin.texts.edit', $text));
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Model\Text $text
     * @return \Illuminate\Http\Response
     */
    public function destroy(Text $text)
    {
        $text->delete();

        return back();
    }


    public function photo(Text $text, StorePhoto $request)
    {
        // we got a re-arange of photos.
        if ($list = $request->get('priority')) {
            foreach ($list as $key => $item) {
                // or $user->photos()->whereId($item['id'])->get()->first();
                $photo = $text->photos()->find($item['id']);
                $photo->priority = $item['priority'];
                $photo->save();
            }
            return;
        }

        // delete photo
        if ($request->method() === 'DELETE') {
            $photo = $text->photos()->find($request->get('id'));
            if ($photo) {
                $photo->delete();
            }
            return;
        }

        // upload the photo.
        $photo = new TextPhoto();
        $photo->text_id = $text->id;

        // go ask for a upload.
        $photo->upload($request->file('photo'));

        // save photo to the text
        $text->photos()->save($photo);

        // return the view again
        return view('admin.text.photo.item', compact('text', 'photo'));
    }

    public function photos(Text $text)
    {
        // return in froala style
        return $text->photos->map(function ($item) {
            $item->use_absolute_path = false;
            return [
                'url' => $item->getPhotoUrl(),
                'thumb' => $item->getThumbUrl(),
            ];
        });
    }

    /**
     * Text  search
     *
     * @param Request $request
     * @return type
     */
    public function search(Request $request)
    {
        $items = [];
        if (strlen($request->get('q')) >= 1) {
            // filter the categories boy.
            $items = Text::where(function ($q) use ($request) {
                $q->where('name', 'like', '%' . $request->get('q') . '%')
                    // @todo do this only if integer is in query.
                    ->orWhere('id', '=', (int)$request->get('q'));
            })
                ->where('id', '!=', $request->id)
                ->limit(100)
                ->get();
            // we are interested only in this format
            $items = $items->map(function ($item) {
                return [
                    'id' => $item->id,
                    'photo' => $item->getThumbUrl(),
                    'name' => $item->name,
                ];
            });
        }
        // feed the troll
        return response()->json($items);
    }

    public function priority(Request $request)
    {

        foreach ($request->get('priority') as $item) {
            $text = Text::find($item['id']);
            $text->priority = $item['priority'];
            $text->save();
        }
    }

}
