<?php

namespace App\Http\Controllers\Auth;

use App\Helpers\Cart;
use Illuminate\Support\Str;
use Socialite;
use App\Http\Controllers\Controller;
use App\Model\User;


class LoginGoogleController extends Controller
{
    /**
     * Redirect the user to the GitHub authentication page.
     *
     * @return \Illuminate\Http\Response
     */
    public function redirectToProvider()
    {
        if (!Str::contains(url()->previous(), 'login')) {
            session()->put('url.intended', url()->previous());
        }

        config(['services.google.redirect' => (config('services.google.redirect'))]);

        return Socialite::driver('google')
            ->scopes(['email'])
            ->redirect();
    }

    /**
     * Obtain the user information from GitHub.
     *
     * @return \Illuminate\Http\Response
     */
    public function handleProviderCallback()
    {
        try {
            // somehow it doesnt work with state, it's not being set into session.
            $externalUser = Socialite::driver('google')->stateless()->user();
        } catch (\Exception $exception) {
            return redirect()->route('site.')->with('error', 'Nu ati aprobat conectarea sau eroare interna. Incercati din nou');
        }

        // try to find the user in our system.
        $user = User::where('email', $externalUser->getEmail())
            ->orWhere('google_id', $externalUser->getId())
            ->first();

        // if user doesnt exist, create it.
        if (!$user) {
            $user = User::create([
                'email' => $externalUser->getEmail(),
                'name' => $externalUser->getName(),
                'google_id' => $externalUser->getId(),
                'google_data' => $externalUser,
                'ua' => request()->server('HTTP_USER_AGENT'),
                'ip' => request()->ip(),
            ]);
            // otherwise update google_id, if needed
        } elseif (!$user->google_id) {
            $user->google_id = $externalUser->getId();
            $user->google_data = $externalUser;
            $user->save();
        }

        // login user
        auth()->login($user, true);

        return redirect()->intended(route('site.'));

        // redirect to checkout if needed
        if ((new Cart)->count()) {
            return redirect()->route('site.checkout');
        }

        return redirect(route('client.'));
    }
}