<?php

namespace App\Http\Controllers\Client;


use App\Model\Article;

class IndexController extends BaseController
{

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $articles = Article::with('photo', 'category')
            ->whereHas('reviews', function ($q) {
            $q->where('user_id', auth()->id());
        })->paginate(config('pagination.items_per_page'))
            ->appends(request()->except('page'));

        return view('client.index', compact('articles'));
    }

}
