<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Auth;

class Controller extends BaseController
{

    use AuthorizesRequests,
        DispatchesJobs,
        ValidatesRequests;

    public function __construct()
    {
        // 5.3 breaks that ability with anything that uses session, auth, csrf, etc so this is the reasonable alternative in my mind.
        // https://josephsilber.com/posts/2017/01/23/getting-current-user-in-laravel-controller-constructor#table-of-contents

        $this->middleware(function ($request, $next) {

            $this->me = Auth::user();
            $this->is_logged = $this->me;
            $this->is_admin = $this->me && $this->me->isAdmin();

            // we set the user to be avai within all views.
            view()->share('me', $this->me);
            view()->share('is_logged', $this->is_logged);
            view()->share('is_admin', $this->is_admin);


            return $next($request);
        });
    }

}
