<?php

namespace App\Http\Controllers\Site;

use App\Model\Brand;

class BrandController extends BaseController
{

    public function __construct()
    {
        parent::__construct();

        view()->share('current_section', 'brands');

        // show only brands that have Wine products.
        $brands = Brand::all();

        view()->share('brands', $brands);
    }

    public function index()
    {
        $this->loadTexts([
            'brands',
        ]);

        return view('site.brand.index');
    }

    public function show(Brand $brand)
    {
        $category = $brand->getCategory();

        //
//        $products = $brand->products()->active()->priority()
//            ->with('attributes', 'photo')
//            ->take(50)->get();

        return view('site.brand.show', compact('brand', 'category'));
    }

}
