<?php

namespace App\Http\Controllers\Site;

use App\Model\Portfolio;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Http\Requests\StoreReview;
use Route;

//use App\Helpers\ForIT;

class PortfolioController extends BaseController
{

    public function index()
    {
        $portfolios = Portfolio::active()
                        ->with('photo')->get();

        return view('site.portfolio.index', compact('portfolios'));
    }

    public function main(Request $request)
    {
        $portfolio = Portfolio::where('slug', 'main')->first();
        $photos = $portfolio->photos()->paginate(config('pagination.portfolio.items_per_page'))->appends($request->except('page'));;

        return view('site.portfolio.show', compact('portfolio', 'photos'));
    }

    public function show($slug, Portfolio $portfolio)
    {
        if ($portfolio->status == 'hidden') {
            abort(404);
        }

        // redirect if slug changed
        if ($slug != $portfolio->slug) {
            return redirect(route('site.portfolio', [$portfolio->slug, $portfolio]));
        }

        return view('site.portfolio.show', compact('portfolio'));
    }

}
