<?php

namespace App\Http\Controllers\Site;

use App\Model\Article;
use App\Model\Category;
use App\Model\Tag;
use Illuminate\Http\Request;

class SitemapController extends BaseController
{


    public function index()
    {
        $aux = [
            route('site.'),
            route('site.articles.index'),
            route('site.recipes.index'),
        ];

        foreach (Category::active()->recipe()->get() as $category) {
            $aux[] = $category->getUrl();
        }
        foreach (Article::select('id', 'slug')->recipe()->active()->get() as $article) {
            $aux[] = $article->getRecipeUrl();
        }

        foreach (Tag::all() as $tag) {
            $aux[] = $tag->getUrl();
        }

        return response(implode("\n", $aux))->header('Content-Type', 'text');

    }


}
