<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class IsAdmin
{

    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::user() && Auth::user()->isAdmin()) {
            return $next($request);
        } else if (Auth()->check()) {
            return redirect()->route('site.')
                ->with('error', 'Nu aveti drepturi de admin!');
        }
        return redirect()->route('login');
    }

}
