<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreOrder extends FormRequest
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'delivery.firstname' => 'required|min:2',
            'delivery.lastname' => 'required|min:2',
            'delivery.address' => 'required|min:2',
//            'email' =>  $this->create_account && $this->password ? 'required|email|max:255|unique:users,email' : 'required|email',
            'delivery.email' =>  $this->create_account && $this->password ? 'required|email|max:255|unique:users,email' : '',
            'password' => $this->create_account ? 'sometimes|min:1|confirmed' : '',
        ];
    }

}
