<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreProduct extends FormRequest
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->get('attributes')) {
            return [];
        }
        if ($this->get('offer')) {
            return [
                'offer.price' => 'required|numeric'
            ];
        }
        if ($this->get('code') && count($this->all()) <= 4) {
            return [
                'code' => 'required|min:3',
            ];
        }
        return [
            'code' => 'required|min:3',
            'name' => 'required|min:2',
            'categories' => 'required',
            //'quantity' => 'required',
            //'description' => 'required',
            //'brand_id' =>  'required',
        ];
    }

}
