<?php

namespace App\Model\Article;

use App\Model\Photo;


/**
 * App\Model\Article\ArticlePhoto
 *
 * @property int $id
 * @property int $article_id
 * @property string $filename
 * @property int $priority
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Model\Article $item
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticlePhoto newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticlePhoto newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticlePhoto query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticlePhoto whereArticleId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticlePhoto whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticlePhoto whereFilename($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticlePhoto whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticlePhoto wherePriority($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticlePhoto whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class ArticlePhoto extends Photo
{
    protected $thumbWidth = 900;
    protected $width = 2400; // 1980

    protected $entity = 'article';


    public function item()
    {
        return $this->belongsTo('App\Model\Article', $this->getItemForeignKey());
    }
}
