<?php

namespace App\Model;

use App\Helpers\Filters;

/**
 * In many places we need an option to get and save a record.
 * For example, in attributes, attribute_values, etc.
 *
 * v2.
 */
trait Filterable
{

    public function filterInstance()
    {
        if (!$this->filter_name) {
            throw new \Exception('filer_name variable not declared!');
        }
        return Filters::instance();
    }

    public function addFilter()
    {
        return $this->filterInstance()->fromUri()->add($this->filter_name, $this);
    }


    public function toggleFilter()
    {
        return $this->filterInstance()->fromUri()->toggle($this->filter_name, $this);
    }

    public function deleteFilter()
    {
        return $this->filterInstance()->fromUri()->delete($this->filter_name, $this);
    }

    public function hasFilter()
    {
//        return $this->filterInstance()->has($this->filter_name, $this);  // its not on uri yet!  (only for XHR!!!)
        return $this->filterInstance()->fromUri()->has($this->filter_name, $this);
    }


    public function get()
    {
        return $this->filterInstance()->fromUri()->getAttribute($this->filter_name);
    }


}
