<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Cache;
use App\Model\Category;

class WordpressCategory extends Model
{
    protected $table = 'wp_categories';
    protected $guarded = ['id'];
    public $timestamps = false;

    public function findAndSave($slug, $object_id)
    {

        return $this->firstOrCreate([
                    'slug' => $slug,
                    'object_id' => $object_id,
                        ], [
                    'category_id' => Category::where('slug', $slug)->first()->id,
        ]);
    }

}
