<?php

namespace App\Providers;

use App\Model\Article;
use App\Model\Category;
use App\Model\Review;
use App\Model\Text;
use App\Observers\ReviewObserver;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Str;
use Validator;

class AppServiceProvider extends ServiceProvider
{

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Validator::extend(
            'recaptcha', 'App\\Validators\\Recaptcha@validate'
        );

        // set env based of domain
        if (Str::startsWith(request()->getHost(), ['www.dev.', 'dev.'])) {
            config(['app.env' => 'dev']);
        }

//        $brands = Brand::all();
//        view()->share('brands', $brands);
//
//        view()->share('global_texts', Text::whereIn('slug', [
//            'footer_company',
//            'footer_newsletter',
//            'cookie_bar',
//            'new_products_menu',
//        ])->get()->mapWithKeys(function ($item) {
//            return [$item->slug => $item];
//        }));

//        $categories = Category::root()->where('is_visible_in_menu', true)->with('children')->get();
        $categories = Category::priority()->recipe()->active()->get();

//        Cache::delete('top_recipes');
        $recipes = Cache::remember('top_recipes', 600, function () {
            return Article::select(['id','title', 'photo_id', 'slug'])
                ->whereNotNull('photo_id')
                ->with('photo')
                ->recipe()->active()->inRandomOrder()->take(10)->get();
        });

        view()->share('menu_categories', $categories);
        view()->share('top_recipes', $recipes);
        view()->share('all_categories', $categories);


        // quikfix redirect from public bla (happens when comming from an external site??)
        if (request()->isMethod('get')) {
            // request()->server('REQUEST_URI'), '/public/'
            if (Str::startsWith(request()->getRequestUri(), '/public/')) {
                redirect(config('app.url') . '/' . request()->path(), 301)->send();
            }
        }

        setlocale(LC_TIME, 'ro_RO', 'Romanian');
        Carbon::setLocale('ro');

        // observer
        Review::observe(ReviewObserver::class);

        Schema::defaultStringLength(191);

    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

}
