<?php

namespace Icetech\Payment\Gateway\Payment;

/**
 * Description of Payment
 *
 * @author Sergiu
 */
class Response
{

    protected $action;
    protected $error_code;
    protected $error_type;
    protected $error_message;
    protected $external_order_id;

    protected $raw; // full response, for debug purposes.

    public function __construct($data, &$paymentInstance)
    {
        // replace action with standard values
        if (isset($data['action'])) {
            $data['action'] = strtr($data['action'], $paymentInstance->getStatusList());

            // if nothing found, we set it as cancel.
            if (!in_array($data['action'], $paymentInstance->getStatusList())) {
                $data['action'] = $paymentInstance::STATUS_CANCELED;
            }
        }

        // populate class
        foreach ($data as $key => $value) {
            $this->{$key} = $value;
        }

        // if we got an error, overwrite action with proper one
        if ($this->hasError()) {
            $this->action = $paymentInstance::STATUS_ERROR;
        }
    }

    public function getAction()
    {
        return $this->action;
    }

    public function getMessage()
    {
        return $this->error_message;
    }

    public function getErrorCode()
    {
        return $this->error_code;
    }

    public function getErrorType()
    {
        return $this->error_type;
    }

    public function hasError()
    {
        return $this->error_code != 0;
    }

    public function getRaw()
    {
        return $this->raw;
    }

    public function getExternalId()
    {
        return $this->external_order_id;
    }

    public function getData()
    {
        return $this;
    }

}
