<?php

namespace Icetech\Payment\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{

    protected $guarded = ['id'];
    protected $casts = [
        'response' => 'json', // JSON serialize
    ];

    public static function boot()
    {
        parent::boot();

        static::creating(function($model) {
            $model->mode = config('app.env') === 'production' ? 'live' : 'test';
        });
    }

}
