<?php

namespace Icetech\Payment;

use Illuminate\Support\ServiceProvider;
use Psy\Exception\FatalErrorException;


class PaymentServiceProvider extends ServiceProvider
{

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // load config
        $this->mergeConfigFrom(__DIR__ . '/config/payment.php', 'payment');


        $gateway = config('payment.gateway');

        // load selected payment gateway
        $this->mergeConfigFrom(__DIR__ . '/config/' . $gateway . '.php', $gateway);


        // load routes
        $this->loadRoutesFrom(__DIR__ . '/routes/web.php');

        // load migrations
        $this->loadMigrationsFrom(__DIR__ . '/migrations');

        // views
        $this->loadViewsFrom(__DIR__ . '/views', 'payment');

        // bind facade.
        $this->app->singleton('payment', function ($app) use ($gateway) {
            $class = __NAMESPACE__ . '\\Gateway\\' . ucfirst($gateway);
            return new $class;
            //return new PaymentGateway();
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    public function provides()
    {
        return ['payment'];
    }

}
