@extends('layouts.admin')
@section('title', 'Detalii comanda')


@section('actions')

@endsection

@section('content')
<div class="row">

    <div class="col-lg-6">
        <div class="ibox">
            <div class="ibox-title">
                <h1>
                    <span class="pull-right text-success">
                        {{$order->price}} lei
                    </span>
                    Sumar comanda
                
                </h1>
            </div>
            <div class="ibox-content">

                <p>
                    <span class="text-muted">Nr comandă</span> #{{$order->id}} 
                </p>
                <p>
                    <span class="text-muted">Valoare comandă:</span> {{$order->price}} lei  
                </p>
                <p>
                    <span class="text-muted">Transport:</span> {{$order->price_delivery}} lei 
                </p>
                <p>
                    <span class="text-muted">Total de plată:</span> {{$order->price + $order->price_delivery}} lei
                </p>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="ibox">
            <div class="ibox-title bg bg-{{$order->status_class}}">
                <h1>comanda {{$order->status_detail}}</h1>
            </div>
            <div class="ibox-content ">
                <p class="text-uppercase">
                <big>
                    Stare: <span class="text text-{{$order->status_class}}">{{$order->status_detail}}</span>
                </big>
                </p>
                <p>
                    <span class="text-muted">AWB:</span> {!!$order->awb ?: '<span class="text-danger">nu e setat</span>'!!}   
                    &nbsp; &nbsp; &nbsp; 
                    <span class="text-muted">Curier:</span> {!!$order->delivery_company ?: '<span class="text-danger">nu e setat</span>'!!}  
                    &nbsp; &nbsp; &nbsp; 
                    <span class="text-muted">Client anuntat la expediere colet:</span> 
                    @if ($order->delivery_mail_sent)
                    <span class="text-success">da</span>
                    @else
                    <span class="text-danger">nu</span>
                    @endif
                </p>
                <hr/>
                <p>
                    <b>
                        Gestionare comanda
                    </b>
                </p>
                <form method="POST" action="{{route('admin.orders.update', $order)}}">
                    {{csrf_field()}}
                    {{method_field('PUT')}}
                    <div class="row form-group">
                        <div class="col-md-4">
                            <input class="form-control" name="awb" placeholder="codul awb" value="{{$order->awb}}" />
                        </div>
                        <div class="col-md-4">
                            <select class="form-control" name="delivery_company" required>
                                <option value="">Selectati curierul</option>
                                @foreach ($order->getDeliveryCompaniesArray() as $company)
                                <option value="{{$company}}" {{$order->delivery_company == $company ? 'selected' : ''}}>
                                    {{$company}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <select class="form-control"  name="status" >
                                @foreach ($order->getStatusArray() as $key => $value)
                                <option value="{{$key}}" {{$order->status == $key ? 'selected' : ''}}>
                                    {{$value}}
                                </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    @if ($order->status == 'in_delivery')
                    <div class="form-group  pull-right">
                        <a href="{{route('admin.order.delivery', $order)}}"  id="yoyaye" class="btn {{$order->delivery_mail_sent ? 'btn-default' : 'btn-success' }}" onclick="this.setAttribute('disabled', true);
                                setTimeout(function () {
                                    this.removeAttribute('href')
                                }.bind(this), 10)">Trimite email comanda expediata</a>
                    </div>
                    @endif


                    <div class="form-group">
                        <button class="btn btn-success">Actualizeaza</button>
                    </div>
                </form>
            </div>
        </div>
        @if ($order->isCC())

        <div class="ibox">
            <div class="ibox-title  bg bg-{{$order->getPaymentStatusClass()}}">
                <h1>
                    <i class="fa far fa-credit-card"></i> 
                    Procesare prin Card
                </h1>
            </div>
            <div class="ibox-content">
                <div class="row">
                    <div class="col-md-6">
                        <h1>
                            <span class="text-{{$order->getPaymentStatusClass()}}">
                                <i class="fa far {{$order->hasValidPayment() ? 'fa-check-circle': 'fa-times-circle'}}"></i> {{$order->getPaymentStatusMessage()}}
                            </span>
                        </h1>

                        <p>
                            <span class="text-muted">Cod comanda:</span> <b>{{$order->code}}</b>
                        </p>
                        <p>
                            <span class="text-muted">Status:</span> {{$order->payment_status}}   
                        </p>
                        @if ($order->transaction)
                        <p>
                            <span class="text-muted">Mesaj procesator plata:</span> <b class="{{$order->transaction->has_error ? 'text-danger' : ''}}">{{$order->transaction->status_text}}</b>
                        </p>
                        @endif

                        <p>
                            <span class="text-muted">Cod status:</span> {{$order->payment_status_code}} 
                        </p>

                        <p>
                            <span class="text-muted">Mediu:</span> {{$order->payment_mode}} 
                        </p>
                        @if ($order->isTest())
                        <div class="text-danger h2">
                            TEST MODE
                        </div>
                        @endif
                    </div>

                    <div class="col-md-6">
                        <h3>Tranzactii</h3>
                        @foreach ($order->transactions()->orderByDesc('id')->get() as $transaction)
                        @dump($transaction->only('id', 'mode', 'status_code', 'status', 'status_text', 'has_error', 'created_at', 'response'))
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        @endif
    </div>
</div>


<div class="row">
    <div class="col-lg-6">
        <div class="ibox">
            <div class="ibox-title">
                <h1>Date livrare</h1>
            </div>
            <div class="ibox-content">
                <p>
                    <span class="text-muted">Nume si Prenume:</span> {{$order->deliveryContact->getName()}}  
                </p>
                <p>
                    <span class="text-muted">Adresa:</span> {{$order->deliveryContact->address}}, {{$order->deliveryContact->postalcode}}, {{$order->deliveryContact->city}}, {{$order->deliveryContact->county->name}}.
                </p>
                <p>
                    <span class="text-muted">Telefon:</span> {{$order->deliveryContact->phone}} 
                </p>
                <p>
                    <span class="text-muted">Email:</span> {{$order->deliveryContact->email}} 
                </p>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="ibox">
            <div class="ibox-title">
                <h1>Date facturare</h1>
            </div>
            <div class="ibox-content">
                @if ($order->delivery_contact_id == $order->billing_contact_id)
                Aceleasi date ca la livrare.
                @else
                <p>
                    <span class="text-muted">Nume si Prenume:</span> {{$order->billingContact->getName()}}  
                </p>
                <p>
                    <span class="text-muted">Adresa:</span> {{$order->billingContact->address}}, {{$order->billingContact->postalcode}}, {{$order->billingContact->city}}, {{$order->billingContact->county->name}}.
                </p>
                <p>
                    <span class="text-muted">Telefon:</span> {{$order->billingContact->phone ?: $order->deliveryContact->phone}} 
                </p>
                <p>
                    <span class="text-muted">Email:</span> {{$order->billingContact->email ?: $order->deliveryContact->email}} 
                </p>
                @endif
            </div>
        </div>
    </div>
</div>

@if ($order->remarks)
<div class="ibox">
    <div class="ibox-title">
        <h1>Mentiuni comanda</h1>
    </div>
    <div class="ibox-content">
        {!!nl2br(StringOperation::disableHtmlTags($order->remarks))!!}

    </div>
</div>
@endif



<div class="ibox">
    <div class="ibox-title">
        <h1>Lista produse</h1>
    </div>
    <div class="ibox-content">

        <table class="table table-striped-or-not table-hover">
            <thead>
                <tr>
                    <th>Produs</th>
                    <th class="bg-muted">Cod</th>
                    <th>Cantitate</th>
                    <th>Pret</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($order->products as $product)
                <tr>
                    <td>
                        @if ($product->product)
                        <a href="{{$product->product->getUrl()}}">
                            <img src="{{$product->product->getThumbUrl()}}" width="50" style="vertical-align: middle; width: 50"  /> {{$product->name}}
                        </a>
                        @else 
                        {{$product->name}} <span class="text text-danger">(produs sters)</span>
                        @endif
                    </td>
                    <td class="bg-muted">
                        {{$product->product ? $product->product->code : '-'}}   
                    </td>
                    <td>
                        {{$product->qty}}   
                    </td>

                    <td>
                        {{$product->price*$product->qty}} lei  
                    </td>
                    @endforeach
            </tbody>
        </table>

    </div>
</div>
@endsection
