
/***
 * Photo upload wrapper
 * (c) Sergiu Draga
 * 
 * Example in:
 * /Users/sergiu/WorkProjects/Pintago/src/resources/views/common/fragment/photo/photos.blade.php
 * 
 * @param {type} className
 * @returns {undefined}
 */
function PhotosUpload(className) {
    this.className = className || '.ui-photos';
    this.element = $(this.className);
    if (this.element.length === 0) {
        return;
    }
    // we need the last col for appending class names to new elements.
    this.lastCol = this.element.children().last();
    if (this.element.hasClass('sortable')) {
        this.sortable();
    }
    this.init();
}

PhotosUpload.prototype.sortable = function () {
    this.element.sortable({
        cursor: "move",
        placeholder: this.lastCol.attr('class') + " bg-gray",
        items: "> div:not(.ui-state-disabled)",
        deactivate: function (event) {
            aux = [];

            // get idx an indexes
            $.each($(event.target).children('div'), function (index, item) {
                var id = $(item).data('id');
                if (!id) {
                    return;
                }
                aux.push({
                    id: id,
                    priority: index,
                });
            });
            
            $('#item_id')

            // sent the new positions.
            $.ajax({
                url: $(this).data('url'),
                data: {
                    priority: aux,
                    item_id: $('#item_id').length ? $('#item_id').val() : null,
                    user_id: $('#user_id').length ? $('#user_id').val() : null,
                },
                method: 'post',
            });
        },
        create: function () {
            // fix: https://stackoverflow.com/a/7796705/1894856
            var list = this;
            resize = function () {
                jQuery(list).css("min-height", "0");
                jQuery(list).height(jQuery(list).height());
            };
            jQuery(list).css('min-height', jQuery(list).height());
        }
    }).disableSelection();
    //$( ".ui-photos div" ).disableSelection();
}

PhotosUpload.prototype.init = function () {
    _this = this;
    // file choser button event
    this.element.find('.ui-photos-trigger').click(function (e) {
        _this.element.find('.ui-photos-file-handler').click();
        e.preventDefault();
    });

    // upload events
    this.element.find('.ui-photos-file-handler').change(function () {
        // files
        var files = $(this).prop('files');

        // process each file.
        $(files).each(function (key, item) {
            // create a placeholder col
            var element = $('<div/>').addClass(_this.lastCol.attr('class'))
                    .addClass('placeholder');
            //.css('display', 'none');

            // add spiner
            element.spin();

            // insert it before the "add button" (last col)
            _this.lastCol.before(element);
            //element.slideDown();

            // go send requests.
            var itemId = $('#item_id');
            
            // user id (so in case of admin we can edit user photos)
            var userId = $('#user_id');

            var formData = new FormData();
            formData.append('photo', item);

            // sometimes we neeed to upload to a diferent scope 
            // (eg: photos cover, master id is the photo ID)
            if (itemId.length) {
                formData.append('item_id', itemId.val());
            }
             if (userId.length) {
                formData.append('user_id', userId.val());
            }
            
            $.ajax({
                url: _this.element.data('url'),
                data: formData,
                contentType: false,
                processData: false,
                method: 'post',
            }).done(function (response) {
                element.html(response);
                element.removeClass('placeholder').removeClass('ui-state-disabled');
                element.data('id', element.find('.item-wrapper').data('id'));
                element.unspin();
            }).fail(function () {
                alert('O eroare a intervenit la urcarea pozei. Va rugam reincercati!');
                element.remove();
            });

        });
    });

    // delete event.
    this.element.on('click', '.item-delete', function () {
        // we need it removed as clicked, otherwise user thinks is an error (on longer requests).
        $(this).closest('.item').remove();
        
        $.ajax({
            url: $(this).data('url'),
            method: 'delete',
        }).done(function () {
            
        }.bind(this));
    });
}
