@extends('layouts.admin')
@section('title', $ad->exists ? "Editare {$ad->name}" : 'Creare ad nou')

@section('content')

    <div class="tabs-container">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#tab-1" aria-expanded="true">De baza</a></li>

        </ul>
        <div class="tab-content">
            <div id="tab-1" class="tab-pane active">
                <div class="panel-body">
                    <p class="alert alert-warning">
                        Atentie! Pozele urcate nu sunt post-procesate (nu sunt redimensionate).
                    </p>
                    <form action="{{route($ad->exists ? 'admin.ads.update' : 'admin.ads.store', $ad)}}" method="POST" class="form-horizontal"
                          enctype="multipart/form-data">

                        {{ method_field($ad->exists ? 'PUT' : 'POST' ) }}
                        {{ csrf_field() }}

                        <div class="row">
                            <div class="col-md-8 col-lg-8">
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Nume</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="title" value="{{ (old('title')) ?: $ad->title }}"
                                               class="form-control" autofocus="autofocus" required/>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Url</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="url" value="{{ (old('url')) ?: $ad->url }}"
                                               class="form-control" autofocus="autofocus" required/>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Poza</label>
                                    <div class="col-sm-10">
                                        @if ($ad->photo)
                                            <img src="{{$ad->getPhotoUrl()}}" class="img-responsive"/>
                                        @endif
                                        <input type="file" name="photo" class="form-control"/>
                                    </div>
                                </div>

                            </div>
                            <div class="col-md-4 col-lg-4">
                                <div class="ibox">
                                    <div class="ibox-content bg-muted">
{{--                                        <div class="form-group">--}}
{{--                                            <label class="col-sm-2 control-label"></label>--}}
{{--                                            <div class="col-sm-10">--}}
{{--                                                <label class="checkbox-inline">--}}
{{--                                                    <input type="hidden" name="is_featured" value="0"/>--}}
{{--                                                    <input type="checkbox" name="is_featured" value="1" class="i-checks"--}}
{{--                                                           @if ($ad->is_featured)--}}
{{--                                                           checked="checked"--}}
{{--                                                            @endif--}}
{{--                                                    /> Apare la recomandate (evidentiate)--}}
{{--                                                </label>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}

                                        <div class="form-group">
                                            <label class="col-sm-3 control-label">Vizibilitate</label>
                                            <div class="col-sm-9">
                                                <select name="visibility" class="form-control">
                                                    @foreach ($ad->getPossibleEnumValues('visibility') as $value)
                                                        <option value="{{$value}}"
                                                                {{ $ad->visibility == $value ? 'selected=selected' : '' }}>
                                                            {{$value}}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-sm-2 control-label"></label>
                                            <div class="col-sm-10">
                                                <label class="checkbox-inline">
                                                    <input type="hidden" name="is_active" value="0"/>
                                                    <input type="checkbox" name="is_active" value="1" class="i-checks"
                                                           @if ($ad->is_active)
                                                           checked="checked"
                                                            @endif
                                                    /> Activ
                                                </label>
                                            </div>
                                        </div>


{{--                                        <div class="form-group">--}}
{{--                                            <label class="col-sm-2 control-label"></label>--}}
{{--                                            <div class="col-sm-10">--}}
{{--                                                <label class="checkbox-inline">--}}
{{--                                                    <input type="hidden" name="show_on_mobile" value="0"/>--}}
{{--                                                    <input type="checkbox" name="show_on_mobile" value="1" class="i-checks"--}}
{{--                                                           @if ($ad->show_on_mobile)--}}
{{--                                                           checked="checked"--}}
{{--                                                            @endif--}}
{{--                                                    /> Afiseaza pe mobil--}}
{{--                                                </label>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}

{{--                                        @if ($ad->exists)--}}
{{--                                            <div class="alert alert-warning  lead">--}}
{{--                                                <b>{{$ad->hits}}</b> clicks--}}
{{--                                            </div>--}}
{{--                                        @endif--}}

                                    </div>
                                </div>

                            </div>
                        </div>


                        <div class="hr-line-dashed"></div>
                        <div class="form-group">
                            <div class="col-sm-4 col-sm-offset-2">
                                <button class="btn btn-primary" type="submit">Salveaza</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>


    </div>

@endsection
