@extends('layouts.admin')
@section('title', 'Stiri recomandate')

@section('actions')
    <a href="{{route('admin.articles.index')}}" class="btn btn-default m-md">
        <i class="fa fa-arrow-left"></i>
        inapoi in lista
    </a>
@endsection

@section('content')
    <style>
        .col:nth-child(8) ~ .col {
            opacity: 0.3;
        }
        .col:nth-child(6) ~ .col .manually_prioritized {
            opacity: 0;
        }
    </style>
    <div class="ibox">
        <div class="ibox-content">
            <div class="row sortable" data-url="{{route('admin.articles.priority')}}">
                @foreach($articles as $article)
                    <div class="col col-md-3 col-lg-3" data-id="{{$article->id}}">
                        <div class="ibox">
                            <div class="ibox-content product-box">

                                <div class="product-imitation"
                                     style="background-image: url('{{$article->getPhotoUrl()}}');">

                                </div>
                                <div class="product-desc">
                                    <div class="pull-right">
                                        <a href="{{route('admin.articles.edit', $article)}}"
                                           class="btn btn-xs btn-outline btn-primary">Edit <i
                                                    class="fa fa-long-arrow-right"></i> </a>
                                    </div>
                                    <small class="text-muted">
                                        <span class="badge {{$article->isActive() ? 'bg-success' : 'bg-danger'}}">
                                            {{$article->isActive() ? 'activ' : 'inactiv'}}
                                        </span>
                                        Pozitie
                                        <span class="product-position">
                                            {{$article->priority}}
                                        </span>
                                    </small>

                                    <span class="manually_prioritized badge badge-warning"  data-manually="{{$article->is_manually_prioritized ? 1 : 0}}">{{$article->is_manually_prioritized && $loop->index < config('featured.max_manually_prioritized') ? 'extra priority' : ''}}</span>


                                    <span class="product-name">

                                        <a href="{{route('admin.articles.edit', $article)}}">
                                            {{$article->title}}
                                        </a>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            @include('admin.parts.sortable')

        </div>
    </div>
@endsection
