@if (!empty($step_categories))
    @foreach ($step_categories as $step_category)
        <div class="col-md-6 m-b-md">
            <div class="border text-left p-sm  bg-muted" style="    box-shadow: 0 0 3px rgb(0 0 0 / 30%);">
                <div class="form-group">
                    <div class="col-sm-12">
                        <input type="text" name="steps[{{$loop->index}}][name]"
                               value="{{$step_category->name}}"
                               class="form-control"
                               placeholder="Nume categorie pasi (ex. Mod de preparare)"
                               class="form-control">
                    </div>
                </div>

                <div class="form-group">
                    <div class="col-sm-12">
                        {{--                        <ol>--}}
                        @isset ($step_category->steps)
                            @foreach ($step_category->steps as $step)
                                <div class="text- font-bold text-uppercase small m-t-or-not m-b-xs">
                                    <button
                                            data-confirm="Sigur stergeti pasul?"
                                            data-url="{{route('admin.articles.steps.delete', [$article, $loop->parent->index, $loop->index])}}"
                                            type="button"
                                            class="btn btn-sm no-padding text-uppercase text-danger pull-right ajax-action-trigger">
                                        <span class="small">
                                            <i class="fa fa-times"></i> sterge pas
                                        </span>
                                    </button>
                                    Pasul {{$loop->iteration}}
                                </div>
                                <div class="m-b-or-not border-bottom m-b">
                                    <div class="row no-margins">
                                        <div class="col-md-3 no-padding m-b">
                                            <div class="" style="background: #f0f0f0;">
                                                <img
                                                        class=""
                                                        style="max-width: 100%; width: 600px; height: 110px; object-fit: cover"
                                                        src="{{$article->getStepPhotoUrl($step)}} "/>
                                                <button type="button"
                                                        data-toggle="modal"
                                                        data-target="#step-photo-picker"
                                                        data-step-category-index="{{$loop->parent->index}}"
                                                        data-step-index="{{$loop->index}}"
                                                        style="border-radius: 0"
                                                        class="btn btn-block btn-info ">Schimba poza
                                                </button>
                                            </div>
                                        </div>
                                        <div class="col-md-9 no-padding m-b">
                                            <input type="hidden"
                                                   class="form-control"

                                                   name="steps[{{$loop->parent->index}}][steps][{{$loop->index}}][filename]"
                                                   value="{{$step->filename}}">
                                            <textarea
                                                    placeholder="Text pt pas aici..."
                                                    class="form-control"
                                                    rows="10"
                                                    name="steps[{{$loop->parent->index}}][steps][{{$loop->index}}][text]">{{$step->text}}</textarea>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endisset
                        {{--                        </ol>--}}
                        <div class="text-right">
                            <button
                                    data-url="{{route('admin.articles.steps.add', [$article, $loop->index])}}"

                                    type="button" class="btn btn-success btn-sm ajax-action-trigger">
                                + Adauga pas nou
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
@endif

<div class="{{empty($step_categories) ? 'col-md-12' : 'col-md-6'}} text-center">
    <button type="button"
            data-url="{{route('admin.articles.steps.category', $article)}}"
            class="btn btn-secondary p-lg  ajax-action-trigger">
        <i class="fa fa-plus-circle fa-5x"></i>
        <div class="h4">
            Adauga categorie cu <b>pasi</b>
        </div>
    </button>
</div>

<script>
    $('.steps-xhr').xhrAction();
</script>

<!-- Model -->
<div class="modal" id="step-photo-picker" tabindex="-1"
     role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h3 class="modal-title" id="myModalLabel">Alege poza pt pas</h3>
            </div>
            <div class="modal-body">
                <p>
                    Se incarca..
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Anuleaza</button>
            </div>
        </div>
    </div>
</div>
<script>
    $('#step-photo-picker').on('show.bs.modal', function (e) {
        // e.relatedTarget.href
        var url = '{{route('admin.articles.photos', [$article, 'render_as_html' => true])}}';
        $(this).find('.modal-body')
            .load(url + '?' + $.param( e.relatedTarget.dataset));
    });

    $('#step-photo-picker').on('hide.bs.modal', function (e) {
        // e.relatedTarget.href
        $(this).find('.modal-body').html('Loading');
    });
</script>
