@extends('layouts.admin')
@section('title', 'Brands')


@section('actions')
    <a href="{{route('admin.brands.create')}}" class="btn btn-primary m-md">
        <i class="fa fa-plus-circle"></i>
        adauga brand
    </a>
@endsection

@section('content')
    <div class="ibox">
        <div class="ibox-content">
            <table class="table table-striped-or-not table-hover">
                <thead>
                <tr>
                    <th>Nume</th>
{{--                    <th>Logo</th>--}}
{{--                    <th>Poza</th>--}}
{{--                    <th class="text-right">Descriere</th>--}}
                    <th class="text-right">Actiuni</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($brands as $brand)
                    <tr role="button">
                        <td>
                            <b>
                                {{$brand->name}}
                            </b>
                            {{--                        <div class="text-primary">--}}
                            {{--                            {{$brand->url}}--}}
                            {{--                        </div>--}}

                            <br/>
                            @if ($brand->is_featured)
                                <span class="badge badge-success">
                                    featured
                                </span>
                            @endif
                        </td>
{{--                        <td>--}}
{{--                            @if ($brand->hasLogo())--}}
{{--                                <img src="{{$brand->getLogoUrl()}}" style="max-height: 60px"/>--}}
{{--                            @endif--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            @if ($brand->hasPhoto())--}}
{{--                                <img src="{{$brand->getPhotoUrl()}}?{{rand()}}" style="max-height: 60px"/>--}}
{{--                            @endif--}}
{{--                        </td>--}}
{{--                        <td class="text-right">--}}
{{--                            @if ($brand->description)--}}
{{--                                <span class="badge badge-primary">--}}
{{--                            da--}}
{{--                        </span>--}}
{{--                            @else--}}
{{--                                <span class="badge badge-danger">--}}
{{--                            nu--}}
{{--                        </span>--}}
{{--                            @endif--}}
{{--                        </td>--}}
                        <td class="text-right">
                            <div class="modal" id="item-{{$brand->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                <div class="modal-dialog text-left" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                            <h4 class="modal-title">Stergere obiect</h4>
                                        </div>
                                        <div class="modal-body text-left">
                                            @if ($brand->products->count())
                                                <p>
                                                    Nu puteti sterge aceast brand deoarce sunt asociate produse cu
                                                    el.<br/>
                                                    Asociati produsele pe alt brand si incercati din nou.
                                                </p>
                                            @else
                                                <p>
                                                    Sigur doriti sa stergeti acest brand?
                                                </p>
                                                <p>
                                                    Atentie, produsele care au fost asociate pe acest brand s-ar putea
                                                    sa ramana nelistate!
                                                </p>
                                            @endif
                                        </div>
                                        <div class="modal-footer">
                                            <form action="{{route('admin.brands.destroy', $brand)}}" method="POST">
                                                {{ method_field('DELETE') }}
                                                {{ csrf_field() }}
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                                                    Anuleaza
                                                </button>
                                                @if ($brand->products->count())
                                                    <a href="{{route('admin.products.index', ['brand_id' => $brand->id])}}"
                                                       class="btn btn-primary">vezi produse asociate</a>
                                                @else
                                                    <input type="submit" value="sterge" class="btn btn-danger"/>
                                                @endif
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <a href="{{route('admin.brands.edit', $brand)}}" class="btn btn-edit btn-xs btn-success">edit</a>
                            <a href="#" class="btn btn-xs btn-danger" data-toggle="modal"
                               data-target="#item-{{$brand->id}}">sterge</a>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
