@extends('layouts.admin')
@section('title', $category->exists ? "Editare {$category->name}" : 'Creare categorie noua')

@section('content')
    <div class="tabs-container">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#tab-1" aria-expanded="true">De baza</a></li>
        </ul>
        <div class="tab-content">
            <div id="tab-1" class="tab-pane active">
                <div class="panel-body">

                    {{--                    @empty ($category->parent_id)--}}
                    {{--                        <p class="alert alert-warning">--}}
                    {{--                            Atentie! Pozele urcate la Categorii nu sunt post-procesate (nu sunt redimensionate).--}}
                    {{--                            Aveti grija sa nu urcati poze prea mari (ca si spatiu ocupat pe disk) pt ca ar putea--}}
                    {{--                            ingreuna--}}
                    {{--                            incarcarea pe pagina.--}}
                    {{--                        </p>--}}
                    {{--                    @endempty--}}

                    <form
                        action="{{route($category->exists ? 'admin.categories.update' : 'admin.categories.store', $category)}}"
                        method="POST"
                        enctype="multipart/form-data"
                        class="form-horizontal">
                        <input type="hidden" name="_redirect" value="{{url()->previous()}}" class="form-control">
                        @method($category->exists ? 'PUT' : 'POST')
                        @csrf

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Nume</label>
                            <div class="col-sm-10">
                                <input type="text" name="name" value="{{ (old('name')) ?: $category->name }}"
                                       class="form-control" autofocus="autofocus" required/>
                            </div>
                        </div>

{{--                        @if (!$category->isPage())--}}
{{--                            <div class="row">--}}
{{--                                <div class="col-md-12">--}}
{{--                                    <div class="form-group">--}}
{{--                                        <label class="col-sm-2 control-label">Descriere--}}
{{--                                        </label>--}}
{{--                                        <div class="col-sm-10">--}}
{{--                                            <textarea name="description" class="form-control"--}}
{{--                                                      rows="8">{{ (old('description')) ?: $category->{'description'} }}</textarea>--}}
{{--                                        </div>--}}
{{--                                    </div>--}}
{{--                                </div>--}}

{{--                            </div>--}}
{{--                        @endif--}}


                        @if (!$category->parent_id && false)
                            <div class="form-group gray-bg p-h-lg">
                                <label class="col-sm-2 control-label">Poza</label>
                                <div class="col-sm-10">
                                    @if ($category->photo)
                                        <img src="{{$category->getPhotoUrl()}}" class="img-responsive"
                                             style="max-height: 150px"/>
                                    @endif
                                    <input type="file" name="photo" class="form-control m-t-md"
                                           @if (!$category->exists)
                                           required
                                        @endif
                                    />
                                </div>
                            </div>
                        @endif


                        @if ($category->parent_id)
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Categorie Parinte</label>
                                <div class="col-sm-10">
                                    <select name="parent_id" class="form-control">
                                        <option value="0">
                                            Root (categorie radacina)
                                        </option>

                                        @include('admin.category.items_select')

                                    </select>
                                </div>
                            </div>
                        @endif


                        @if (!$category->isPage())
                        <!-- visiblity -->
                            <input type="hidden" name="show_in_menu" value="0"/>
                            @if (!$category->parent_id)
                                <div class="form-group">
                                    <label class="col-sm-2 control-label"></label>
                                    <div class="col-sm-10">
                                        <label class="checkbox-inline">
                                            <input type="checkbox" name="show_in_menu" value="1" class="i-checks"
                                                   @if ($category->show_in_menu)
                                                   checked="checked"
                                                @endif
                                            /> Vizibil in meniu
                                        </label>
                                    </div>
                                </div>
                            @endif


                            <div class="form-group">
                                <label class="col-sm-2 control-label"></label>
                                <div class="col-sm-10">
                                    <label class="checkbox-inline">
                                        <input type="hidden" name="is_active" value="0"/>
                                        <input type="checkbox" name="is_active" value="1" class="i-checks"
                                               @if ($category->is_active)
                                               checked="checked"
                                            @endif
                                        /> Active
                                    </label>
                                </div>
                            </div>

                            @if (!$category->parent_id)
                                <div class="form-group">
                                    <label class="col-sm-2 control-label"></label>
                                    <div class="col-sm-10">
                                        <label class="checkbox-inline">
                                            <input type="hidden" name="can_have_children" value="0"/>
                                            <input type="checkbox" name="can_have_children" value="1" class="i-checks"
                                                   @if ($category->can_have_children)
                                                   checked="checked"
                                                @endif
                                            /> Poate avea subcategorii
                                        </label>
                                    </div>
                                </div>
                            @endif

                        @endif

                        <div class="hr-line-dashed"></div>
                        <div class="form-group">
                            <div class="col-sm-4 col-sm-offset-2">
                                <button class="btn btn-primary" type="submit">Salveaza</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
