@extends('layouts.admin')
@section('title', $cover->exists ? "Editare {$cover->name}" : 'Creare cover nou')

@section('content')

    <div class="tabs-container">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#tab-1" aria-expanded="true">De baza</a></li>

        </ul>
        <div class="tab-content">
            <div id="tab-1" class="tab-pane active">
                <div class="panel-body">
                    <p class="alert alert-warning">
                        Pozele urcate sunt redimensionate automat la maxim 2000 pixeli.
                        <br/>
                        Dimensiunea recomandata este de 1923 x 1016
                    </p>
                    <form action="{{route($cover->exists ? 'admin.covers.update' : 'admin.covers.store', $cover)}}"
                          method="POST" class="form-horizontal"
                          enctype="multipart/form-data">

                        {{ method_field($cover->exists ? 'PUT' : 'POST' ) }}
                        {{ csrf_field() }}

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Ordine *</label>
                            <div class="col-sm-10">
                                <input type="number" name="priority"
                                       value="{{ (old('priority')) ?: $cover->priority ?? 999 }}"
                                       class="form-control" required/>
                            </div>
                        </div>


                        <div class="form-group">
                            <label class="col-sm-2 control-label">Poza cover *</label>
                            <div class="col-sm-10">

                                {{--                                @if ($cover->hasCatalog())--}}
                                {{--                                    <span class="badge badge-muted">--}}
                                {{--                                        Catalog, nu se ia in considera poza in Slide-uri pe homepage.--}}
                                {{--                                    </span>--}}
                                {{--                                @endif--}}

                                @if ($cover->hasCover())
                                    <img src="{{$cover->getPhotoUrl()}}" class="img-responsive"/>
                                @endif
                                <input type="file" name="photo" class="form-control"/>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Poza produs</label>
                            <div class="col-sm-10">

                                @if ($cover->hasProductPhoto())
                                    <img src="{{$cover->getProductPhotoUrl()}}" class="img-responsive"/>
                                @endif
                                <input type="file" name="product_photo" class="form-control"/>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Titlu
                            </label>
                            <div class="col-sm-10">
                                <input type="text" name="title"
                                       value="{{ ((old('title')) ?: $cover->{'title'}) }}"
                                       class="form-control"
                                >
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Text
                            </label>
                            <div class="col-sm-10">
                                            <textarea name="body" class="form-control"
                                                      rows="8">{{ (old('body')) ?: $cover->{'body'} }}</textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Url
                            </label>
                            <div class="col-sm-10">
                                <input type="text" name="url"
                                       value="{{ ((old('url')) ?: $cover->{'url'}) }}"
                                       class="form-control"
                                >
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Text buton
                            </label>
                            <div class="col-sm-10">
                                <input type="text" name="button_text"
                                       value="{{ ((old('button_text')) ?: $cover->{'button_text'}) }}"
                                       class="form-control"
                                       required
                                >
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label"></label>
                            <div class="col-sm-10">
                                <label class="checkbox-inline">
                                    <input type="hidden" name="is_active" value="0"/>
                                    <input type="checkbox" name="is_active" value="1" class="i-checks"
                                           @if ($cover->is_active || !$cover->exists)
                                           checked="checked"
                                            @endif
                                    /> Active
                                </label>
                            </div>
                        </div>

                        <div class="hr-line-dashed"></div>
                        <div class="form-group">
                            <div class="col-sm-4 col-sm-offset-2">
                                <button class="btn btn-primary" type="submit">Salveaza</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
