@extends('layouts.admin')
@section('title', 'Comentarii')


@section('content')
    <div class="ibox">
        <div class="ibox-content table-responsive">
            <table class="table table-striped-or-not table-hover">
                <thead>
                <tr>
                    <th>Autor</th>
                    <th>Mesaj</th>
		{{--<th>Rating</th>--}}
		<th>Articol</th>
                    <th class="text-right">Actiuni</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($reviews as $review)
                    <tr role="button">
                        <td>
                            @if ($review->user)
                                <a href="{{route('admin.users.edit', $review->user)}}">
                                    {{$review->user->getName()}}
                                </a>
                            @else
                                {{$review->name}} ({{$review->email}})
                            @endif
                        </td>
                        <td>
                            {!!StringOperation::safeText($review->body)!!}
                            @if ($review->hasPhoto())
                                <div>
                                    <a target="_blank" href="{{$review->getPhotoUrl()}}">
                                        <img src="{{$review->getPhotoUrl()}}" class="img-thumbnail m-t-xs" style="max-height: 80px;"/>
                                    </a>
                                </div>
                            @endif
                            <form action="{{route('admin.reviews.update', $review)}}" method="POST" class="m-t-xs">
                                {{ method_field('PUT') }}
                                {{ csrf_field() }}
                                <input type="hidden" name="is_active" value="{{(int)!$review->is_active}}"/>
                                <input type="submit" value="{{$review->is_active ? 'dezaproba' : 'aproba'}}"
                                       class="btn btn-xs {{!$review->is_active ? 'btn-primary' : 'btn-warning'}}"/>


                            </form>

                        </td>
                        {{--<td>--}}
                        {{--{{$review->rating}} <i class="fa fa-star"></i>--}}
			    {{--</td>--}}
                        <td>
                            @if ($review->article)
                                <a href="{{$review->article->getUrl()}}#comment-{{$review->id}}">
                                    {{$review->article->title}}
                                </a>
                            @else
                                articol sters
                            @endif
                        </td>
                        <td class="text-right">
                            <div class="modal" id="item-{{$review->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                <div class="modal-dialog text-left" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                            <h4 class="modal-title">Stergere obiect</h4>
                                        </div>
                                        <div class="modal-body text-left">
                                            <p>
                                                Sigur doriti sa stergeti acest review?
                                            </p>
                                        </div>
                                        <div class="modal-footer">
                                            <form action="{{route('admin.reviews.destroy', $review)}}" method="POST">
                                                {{ method_field('DELETE') }}
                                                {{ csrf_field() }}
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                                                    Anuleaza
                                                </button>
                                                <input type="submit" value="sterge" class="btn btn-danger"/>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <form action="{{route('admin.reviews.update', $review)}}" method="POST">
                                {{ method_field('PUT') }}
                                {{ csrf_field() }}
                                <input type="hidden" name="is_active" value="{{(int)!$review->is_active}}"/>
                                <input type="submit" value="{{$review->is_active ? 'dezaproba' : 'aproba'}}"
                                       class="btn btn-xs {{!$review->is_active ? 'btn-primary' : 'btn-warning'}}"/>

                                <a href="{{route('admin.reviews.edit', $review)}}"
                                   class="btn btn-edit btn-xs btn-success">edit</a>
                                <a href="#" class="btn btn-xs btn-danger" data-toggle="modal"
                                   data-target="#item-{{$review->id}}">sterge</a>
                            </form>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
            <div>
                {{$reviews->links()}}
            </div>
        </div>
    </div>
@endsection
