@extends('layouts.admin')
@section('title', $text->exists ? $text->title : 'Text nou')

@section('content')
    <div class="tabs-container">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#tab-1" aria-expanded="true">De bază</a></li>
        </ul>
        <div class="tab-content">
            <div id="tab-1" class="tab-pane active">
                <div class="panel-body">
                    <form action="{{route($text->exists ? 'admin.texts.update' : 'admin.texts.store', $text)}}"
                          method="POST" class="form-horizontal">
                        {{ method_field($text->exists ? 'PUT' : 'POST' ) }}
                        @csrf
                        <div class="form-group">
                            <label class="col-sm-2 control-label">ID intern</label>
                            <div class="col-sm-10">
                                <input type="text" name="slug" value="{{ (old('slug')) ?: $text->slug }}"
                                       class="form-control"
                                       @if ($text->exists || $text->city_id)
                                       readonly
                                       @else
                                       required
                                    @endif
                                >
                            </div>
                        </div>

{{--                        <input type="hidden" name="has_photos" value="{{ (old('has_photos')) ?: $text->has_photos }}"/>--}}
                        <input type="hidden" name="has_rich_editor"
                               value="{{ (old('has_rich_editor')) ?: $text->has_rich_editor }}"/>


                        <div class="row p-h-lg">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label">Titlu
                                        </label>
                                        <div class="col-sm-10">
                                            <input type="text" name="title"
                                                   value="{{ ((old('title')) ?: $text->{'title'}) }}"
                                                   class="form-control">
                                        </div>
                                    </div>
                                </div>
                        </div>


                        <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label">Descriere
                                        </label>
                                        <div class="col-sm-10">
                                            <textarea name="body" class="form-control rich"
                                                      rows="12">{{ (old('body')) ?: $text->{'body'} }}</textarea>
                                        </div>
                                    </div>
                                </div>
                        </div>


                        <div class="hr-line-dashed"></div>

                        <div class="form-group">
                            <div class="col-sm-4 col-sm-offset-2">
                                <button class="btn btn-primary" type="submit">
                                    @if ($text->exists)
                                        Salveaza
                                    @else
                                        Salveaza si Continua
                                    @endif
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>


            <div id="tab-3" class="tab-pane">
                <div class="panel-body">
                    <div class="dynamic-block">
                    </div>
                </div>
            </div>
            @if ($text->exists && $text->has_photos)
                <div id="tab-5" class="tab-pane">
                    <div class="panel-body">
                        @include('admin.text.photo.index')
                    </div>
                </div>
            @endif
        </div>
    </div>

    <script>
        @if ($text->has_rich_editor)
        $('textarea.rich').froalaEditor({
                height: 200,
                quickInsertButtons: ['table', 'ul', 'ol', 'hr'],
                // ['imageBack', '|', 'imageUpload', 'imageByURL', 'imageManager']
                @if ($text->exists)
                imageManagerLoadURL: '{{route('admin.texts.photos', $text)}}',
                @endif
                imageInsertButtons: ['imageBack', '|', 'imageByURL', 'imageManager'],
                imageUploadRemoteUrls: false,
                imagePaste: false,
                imageDefaultWidth: 300,
                videoInsertButtons: ['videoBack', '|', 'videoByURL'],
                videoUploadRemoteUrls: false,
                fileUpload: false,
                toolbarButtons: ['fullscreen', 'bold', 'italic', 'underline', 'strikeThrough', 'subscript', 'superscript', '|', 'fontFamily', 'fontSize', 'color', 'inlineStyle', 'paragraphStyle', '|', 'paragraphFormat', 'align', 'formatOL', 'formatUL', 'outdent', 'indent', 'quote', '-', 'insertLink', 'insertImage', 'insertVideo', 'embedly', 'insertTable', '|', 'emoticons', 'specialCharacters', 'insertHR', 'selectAll', 'clearFormatting', '|', 'print', 'spellChecker', 'help', 'html', '|', 'undo', 'redo'],
            }
        );
        @endif
    </script>
@endsection
