@extends('layouts.admin')
@section('title', 'Texte')

@section('actions_or_not')
    <a href="{{route('admin.texts.create')}}" class="btn btn-primary m-md">adauga text</a>
@endsection

@section('content')

    <div class="alert alert-warning">
        Fragmente de text prezente prin interfata sitului.
    </div>
    <div class="ibox">
        <div class="ibox-content">
            <div class="row">
                <div class="col-lg-12 table-responsive">
                    <table class="table table-striped-or-not table-hover">
                        <thead>
                        <tr>
                            <th>Identificator</th>
                            <th>Titlu</th>
{{--                            <th>Functionalitati</th>--}}
                            <th>Text</th>
                            <th class="text-right">Actiuni</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($texts as $text)
                            <tr role="button" class="{{$text->city_id ? 'bg-muted' : ''}}">
                                <td class="text-success">
                                    {{$text->slug}}
                                </td>
                                <td style="width: 200px">
                                    {{$text->title}}
                                </td>
{{--                                <td>--}}
{{--                                    @if ($text->has_photos)--}}
{{--                                        <span class="badge badge-success">--}}
{{--                                                poze--}}
{{--                                        </span>--}}
{{--                                    @endif--}}

{{--                                    @if ($text->has_rich_editor)--}}
{{--                                        <span class="badge badge-success">--}}
{{--                                                rich editor--}}
{{--                                        </span>--}}
{{--                                    @endif--}}
{{--                                    --}}
{{--                                </td>--}}
                                <td>
                                    {!! StringOperation::text_limit($text->body, 50)  !!}
                                </td>
                                <td class="text-right">
{{--                                    <div class="modal" id="item-{{$text->id}}" tabindex="-1" role="dialog"--}}
{{--                                         aria-hidden="true">--}}
{{--                                        <div class="modal-dialog text-left" role="document">--}}
{{--                                            <div class="modal-content">--}}
{{--                                                <div class="modal-header">--}}
{{--                                                    <h4 class="modal-title">Stergere obiect</h4>--}}

{{--                                                    <button type="button" class="close" data-dismiss="modal">&times;--}}
{{--                                                    </button>--}}
{{--                                                </div>--}}
{{--                                                <div class="modal-body text-left">--}}
{{--                                                    <p>--}}
{{--                                                        Sigur doriti sa stergeti?--}}
{{--                                                    </p>--}}
{{--                                                </div>--}}
{{--                                                <div class="modal-footer">--}}
{{--                                                    <form action="{{route('admin.texts.destroy', $text)}}"--}}
{{--                                                          method="POST">--}}
{{--                                                        {{ method_field('DELETE') }}--}}
{{--                                                        {{ csrf_field() }}--}}
{{--                                                        <button type="button" class="btn btn-secondary"--}}
{{--                                                                data-dismiss="modal">--}}
{{--                                                            Anuleaza--}}
{{--                                                        </button>--}}
{{--                                                        <input type="submit" value="sterge" class="btn btn-danger"/>--}}
{{--                                                    </form>--}}
{{--                                                </div>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}
{{--                                    </div>--}}
                                    <a href="{{route('admin.texts.edit', $text)}}"
                                       class="btn btn-edit btn-xs btn-success">edit</a>
{{--                                    <a href="#" class="btn btn-xs btn-danger" data-toggle="modal"--}}
{{--                                       data-target="#item-{{$text->id}}">sterge</a>--}}
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
@endsection
