@extends('layouts.admin')

@section('title')
    Modificari baza {{$user->getName()}}
@endsection


@section('content')
    <div class="tabs-container">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#tab-1" aria-expanded="true">De baza</a></li>
            @if ($user->exists)
                                <li class=""><a data-toggle="tab" href="#tab-2" aria-expanded="false">Contacte atasate</a></li>
{{--                <li class=""><a--}}
{{--                            --}}{{--                    data-toggle="tab" --}}
{{--                            href="{{route('admin.users.show', $user)}}" aria-expanded="false">Info Contacte</a></li>--}}
            @endif
        </ul>
        <div class="tab-content">
            <div id="tab-1" class="tab-pane active">
                <div class="panel-body">
                    <form action="{{route('admin.users.update', $user)}}" method="POST" class="form-horizontal">
                        <input type="hidden" name="_redirect" value="{{url()->previous()}}" class="form-control">
                        {{ method_field($user->exists ? 'PUT' : 'POST' ) }}
                        {{ csrf_field() }}
                        <hr/>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Email</label>
                            <div class="col-sm-10">
                                <input type="email" name="email" value="{{ (old('email')) ?: $user->email }}"
                                       class="form-control">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Parola noua</label>
                            <div class="col-sm-10">
                                <input type="password" name="new_password" value="" class="form-control">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label"></label>
                            <div class="col-sm-10">
                                <label class="checkbox-inline">
                                    <input type="hidden" name="is_admin" value="0"/>
                                    <input type="checkbox" name="is_admin" value="1" class="i-checks"
                                           @if ($user->isAdmin())
                                           checked="checked"
                                            @endif
                                    /> Administrator
                                </label>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Nume</label>
                            <div class="col-sm-10">
                                <input type="text" name="name" value="{{ (old('name')) ?: $user->name }}"
                                       class="form-control">
                            </div>
                        </div>
                        <div class="hr-line-dashed"></div>
                        <div class="form-group">
                            <div class="col-sm-4 col-sm-offset-2">
                                <button class="btn btn-primary" type="submit">
                                    Salveaza
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div id="tab-2" class="tab-pane">
                @if ($user->exists)
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="ibox">
                                    <div class="ibox-title">
                                        <h1>
                                            Cont
                                        </h1>
                                    </div>
                                    <div class="ibox-content">

                                        <p class="mb-1">
                                            <span class="text-muted">Inregistrat:</span> {{$user->created_at}}
                                        </p>
                                        <p class="mb-1">
                                            <span class="text-muted">Email:</span> {{$user->email}}
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            @if (!empty($user->deliveryContact))
                                <div class="col-lg-6">
                                    <div class="ibox">
                                        <div class="ibox-title">
                                            <h1>
                                                Adresa livrare
                                            </h1>
                                        </div>
                                        <div class="ibox-content">

                                            <p class="mb-1">
                                                <span class="text-muted">Nume si Prenume:</span> {{$user->deliveryContact->getName()}}
                                            </p>
                                            <p class="mb-1">
                                                <span class="text-muted">Adresa:</span> {{$user->deliveryContact->address}}
                                                , {{$user->deliveryContact->postalcode}}
                                                , {{$user->deliveryContact->city}}
                                                , {{$user->deliveryContact->county->name}}.
                                            </p>
                                            <p class="mb-1">
                                                <span class="text-muted">Telefon:</span> {{$user->deliveryContact->phone}}
                                            </p>
                                            <p class="mb-1">
                                                <span class="text-muted">Email:</span> {{$user->deliveryContact->email ?? $user->email}}
                                            </p>
                                        </div>
                                    </div>
                                </div>



                                @if (!empty($user->billingContact))
                                    <div class="col-lg-6">
                                        <div class="ibox">
                                            <div class="ibox-title">
                                                <h1>
                                                    Adresa facturare
                                                </h1>
                                            </div>
                                            <div class="ibox-content">

                                                @if ($user->billingContact->type == 'company')
                                                    <p class="mb-1">
                                                        <span class="text-muted">Nume firmă:</span> {{$user->billingContact->company_name}}
                                                    </p>
                                                    <p class="mb-1">
                                                        <span class="text-muted">CUI:</span> {{$user->billingContact->company_cui}}
                                                    </p>
                                                    <p class="mb-1">
                                                        <span class="text-muted">Nr reg. com.:</span> {{$user->billingContact->company_reg}}
                                                    </p>
                                                    <p class="mb-1">
                                                        <span class="text-muted">Cont bancar:</span> {{$user->billingContact->bankaccount}}
                                                    </p>
                                                @endif

                                                {{--                        <p class="mb-1">--}}
                                                {{--                            <span class="text-muted">Nume si Prenume:</span> {{$user->billingContact->getName()}}--}}
                                                {{--                        </p>--}}
                                                <p class="mb-1">
                                                    <span class="text-muted">Adresa:</span> {{$user->billingContact->address}}
                                                    , {{$user->billingContact->postalcode}}
                                                    , {{$user->deliveryContact->city}}
                                                    , {{$user->deliveryContact->county->name}}.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
    <script>
        $('.i-checks').iCheck({
            checkboxClass: 'icheckbox_square-green',
            radioClass: 'iradio_square-green',
        });
    </script>

@endsection
