@extends('layouts.admin')

@section('title')
    @lang('Users')
@endsection


@section('actions')
    @if (count(request()->except('page')))
        <div class="btn-group m-t-lg">
            <a href="{{route('admin.users.index')}}" class="btn btn-danger">
                Anuleaza filtre
            </a>
        </div>
    @endif

    {{--    <div class="btn-group m-t-lg">--}}
    {{--        <button type="button" class="btn btn-default dropdown-toggle {{request()->has('status') ? 'active' : ''}}"--}}
    {{--                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">--}}
    {{--            Tip useri <span class="caret"></span>--}}
    {{--        </button>--}}
    {{--        <ul class="dropdown-menu">--}}
    {{--            @foreach (['reseller' => 'Resellers', 'regular' => 'Useri standard'] as $key => $value)--}}
    {{--                <li class="{{request('type') == $key ? 'active' : ''}}"><a--}}
    {{--                            href="{{route('admin.users.index', ['type' => $key] + request()->except('page'))}}">{{$value}}</a>--}}
    {{--                </li>--}}
    {{--            @endforeach--}}
    {{--            <li role="separator" class="divider"></li>--}}
    {{--            <li><a href="{{route('admin.users.index', request()->except('type', 'page'))}}">Toti</a></li>--}}
    {{--        </ul>--}}
    {{--    </div>--}}
@endsection


@section('content')

    <div class="ibox">
        <div class="ibox-content">
            <form action="{{route('admin.users.index')}}" method="GET" class="form-horizontal">

                <input type="text" name="q" class="form-control" placeholder="Cauta"/>
                @foreach (request()->except('q') as $key => $value)
                    <input type="hidden" name="{{$key}}" value="{{$value}}"/>
            @endforeach
            <!--            <div class="input-group">
                <span class="input-group-btn">
                    <div class="dropdown">
                        <a class="btn btn-secondary dropdown-toggle" href="https://example.com" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Filtrare
                        </a>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                            <a class="dropdown-item {{!request('status') ? 'active' : ''}}" href="{{route('admin.users.index')}}">Toti</a>
                            <a class="dropdown-item {{request('status') === 'pending' ?  'active'  : ''}}" href="{{route('admin.users.index', ['status' => 'pending'])}}">Necesita aprobare</a>
                            <a class="dropdown-item {{request('status') === 'active' ?  'active'  : ''}}" href="{{route('admin.users.index', ['status' => 'active'])}}">Activi</a>
                            <a class="dropdown-item {{request('status') === 'inactive' ? 'active'  : ''}}" href="{{route('admin.users.index', ['status' => 'inactive'])}}">Inactivi</a>
                            <a class="dropdown-item {{request('status') === 'new' ? 'active'  : ''}}" href="{{route('admin.users.index', ['status' => 'new'])}}">Noi</a>
                        </div>
                    </div>
                </span>
            </div>-->
            </form>
            @if (request('q'))
                <div class="pt-3 pb-3 alert alert-warning">
                    Rezultate pentru <b>{{request('q')}}</b>
                </div>
            @endif

        </div>
    </div>

    <div class="ibox">
        <!--
        <div class="ibox-title">
            <h5>Gestionare categorii</h5>
        </div>
        -->
        <div class="ibox-content table-responsive">
            <table class="table table-striped-or-not table-hover">
                <thead>
                <tr>
                    <th>Username</th>
                    <th>Email</th>
                    <th>Inregistrare</th>
                    {{--                    <th>Role</th>--}}
                    {{--                    <th>Status</th>--}}
                    <th class="text-right">Actions</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($users as $user)
                    <tr role="button"
                        class="
@if ($user->isAdmin())
                                text-primary
@endif">
                        <td>
                            <a
                                    class="btn btn-sm btn-default pull-right btn-edit"
                                    href="{{route('admin.orders.index', ['user_id' => $user->id])}}">
                                vezi comenzi
                            </a>
                            {{ $user->getName() }}

                            @if ($user->isAdmin())
                                <span class="badge badge-primary">
                                    admin
                                </span>
                            @endif
                        </td>
                        <td>{{$user->email}}</td>
                        <td>{{$user->created_at}}</td>
                        {{--                        <td>--}}
                        {{--                            {{$user->isAdmin() ? 'admin' : ''}}--}}
                        {{--                        </td>--}}
                        {{--                        <td>--}}
                        {{--                            <span class="badge badge-{{$user->status == 'active' ? 'info' : 'warning'}}">{{$user->status}}</span>--}}
                        {{--                        </td>--}}
                        <td class="text-right">

                            <form action="{{route('admin.users.update', $user)}}" method="POST">
                                {{ method_field('PUT') }}
                                {{ csrf_field() }}
                                <input type="hidden" name="is_active" value="{{(int)!$user->is_active}}"/>
                                <div class="btn-group">
                                    <a href="{{route('admin.users.show', $user->id)}}"
                                       class="btn btn-xs btn-default">info</a>

                                    <a href="{{route('admin.users.edit', $user->id)}}"
                                       class="btn btn-xs btn-success">edit</a>

                                @if ($me->id !== $user->id)
                                    <!-- Modal -->
                                        <div class="modal text-left" id="user-{{$user->id}}" tabindex="-1" role="dialog"
                                             aria-labelledby="StergereUser" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">Stergere user</h4>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                                aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body text-left">
                                                        <p>
                                                            Sigur doriti sa stergeti aceast user?

                                                        </p>
                                                        <p>
                                                            Actiunea este permantenta!
                                                        </p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <form action="{{route('admin.users.destroy', $user)}}"
                                                              method="POST">
                                                            {{ method_field('DELETE' ) }}
                                                            {{ csrf_field() }}
                                                            <button type="button" class="btn btn-secondary"
                                                                    data-dismiss="modal">Anuleaza
                                                            </button>
                                                            <input type="submit" value="Sterge"
                                                                   class="btn btn btn-secondary  btn-danger"/>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <button type="button" class="btn btn-xs btn-danger" data-toggle="modal"
                                                data-target="#user-{{$user->id}}">
                                            sterge
                                        </button>
                                    @endif
                                </div>
                            </form>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
            <div>
                {{$users->links('vendor.pagination.bootstrap')}}
            </div>
        </div>
    </div>


@endsection
