@extends('layouts.client')
@section('title', __('Addresses'))

@section('subcontent')

    <div class="font-md font-weight-semibold mb-4">
        Adresele mele
    </div>



    <div class="row">

        @if (!isset($me->deliveryContact, $me->billingContact))
            <div clas="col-12 lead text-muted">
                La prima comanda se adauga adresele.
            </div>
        @endif

        @if ($me->billingContact)
            <div class="col-lg-6 ">
                <div class="main-address bg-white shadow-sm border border-light-gray rounded p-4 d-md-inline-block-or-not mb-4"
                     style="min-width: auto">
                    <div class="font-weight-bold text-uppercase font-weight-bold letter-spacing-24 text-dark">
                        @lang('Invoice address')
                    </div>

                    <div class="my-3 pb-2 font-small">
                        @if ($me->billingContact->type == 'company')
                            <p class="mb-2">
                                {{$me->billingContact->company_name}} <span
                                        class="font-weight-bold">
                                                                        (@lang('The invoice is made on the company'))
                                                                    </span>
                            </p>
                        @else
                            <div class="mb-2">
                                {{$me->billingContact->getName()}}
                            </div>
                        @endif
                        <p class="mb-0">
                            {{$me->billingContact->address}}
                            {{--                                            , {{$me->billingContact->postalcode}}--}}
                        </p>
                        <p class="mb-0">{{$me->billingContact->city}}
                            , {{$me->billingContact->county->name ?? '-?'}}</p>
                    </div>

                    <a href="{{route('client.contacts.edit', $me->billingContact->id)}}"
                       class="btn btn-outline-secondary text-black mr-2 mr-lg-3">
                        <span class="font-xs font-weight-medium px-4">Modifică</span>
                    </a>


                </div>
            </div>
        @endif

        @if ($me->deliveryContact)
            <div class="col-lg-6">
                <div class="main-address bg-white shadow-sm border border-light-gray rounded p-4 d-md-inline-block-or-not mb-4"
                     style="min-width: auto">
                    <div class="font-weight-bold text-uppercase font-weight-bold letter-spacing-24 text-dark">
                        @lang('Delivery address')
                    </div>
                    @if (!$me->billingContact && $me->deliveryContact)
                        <div class="text-success pt-3">
                            Se folosește adresa de facturare.
                        </div>
                    @else
                        <div class="my-3 pb-2 font-small">
                            <p class="mb-2">
                                {{$me->deliveryContact->getName()}}
                            </p>
                            <p class="mb-0">
                                {{$me->deliveryContact->address}}
                                {{--                                        , {{$me->deliveryContact->postalcode}}--}}
                            </p>
                            <p class="mb-0">{{$me->deliveryContact->city}}
                                , {{$me->deliveryContact->county->name}}</p>
                        </div>


                        <a href="{{route('client.contacts.edit', $me->deliveryContact->id)}}"
                           class="btn btn-outline-secondary text-black mr-2 mr-lg-3">
                            <span class="font-xs font-weight-medium px-4">Modifică</span>
                        </a>

                    @endif


                </div>
            </div>
        @endif


    </div>

@endsection
