@extends('layouts.client')
@section('title', 'Informații personale')

@section('subcontent')
    <div class="font-md font-weight-semibold mb-4">
        Date personale
    </div>

    <form class="" method="post" action="{{route('client.user.update')}}">
        @csrf
        <div class="form-group">
            <label class="font-weight-bold font-small">Nume</label>
            <input type="text" class="form-control"
                   value="{{old('name', $me->name)}}" name="name" required="">
        </div>

        <div class="form-group">
            <label class="font-weight-bold font-small">Email</label>
            <input type="email" class="form-control" name="email"
                   value="{{old('email', $me->email)}}"
                   readonly
            >
        </div>

        <div class="form-group">
            <label class="font-weight-bold font-small">Parola</label>
            <input type="password" class="form-control" name="old_password">
        </div>

        <div class="form-group">
            <label class="font-weight-bold font-small">Parola nouă</label>
            <input type="password" class="form-control" name="new_password">
        </div>

        <div class="form-group">
            <label class="font-weight-bold font-small">Data nașterii</label>
            <input type="date" class="form-control" name="birthday"
                   value="{{old('birthday', $me->birthday)}}"

                   required="">
        </div>


        {{--        <div class="custom-control custom-checkbox mb-3 mb-md-4">--}}
        {{--            <input type="hidden" name="newsletter" value="0">--}}
        {{--            <input name="newsletter" type="checkbox" class="custom-control-input" id="newsletter"--}}
        {{--                   value="1"--}}
        {{--                   @if ($newsletter)--}}
        {{--                       checked--}}
        {{--                    @endif--}}
        {{--            >--}}
        {{--            <label class="custom-control-label font-weight-bold text-dark font-size-base"--}}
        {{--                   for="newsletter">--}}
        {{--                Mă abonez la newsletter--}}
        {{--            </label>--}}
        {{--        </div>--}}
        @include('site.parts.approve_gdpr')


        <button type="submit" class="btn btn-secondary rounded-md py-2 px-4">
            <span class="font-weight-semibold font-xs px-2">Salvează</span>
        </button>

    </form>
@endsection
