<!DOCTYPE html>
<html lang="{{ config('app.locale') }}">
<head>

    <title>@yield('title') | {{config('app.name')}}</title>

    @if (config('app.env') === 'dev')
        <meta name="robots" content="noindex">
    @endif

    <meta name="description" content="@yield('description')">
    <meta name="keywords" content="@yield('keywords')">
    @yield('meta')

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="icon" type="image/png" href="{{asset('assets/site/images/favicon.png')}}">

<!--    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;500;600;700;800&display=swap&subset=latin-ext" rel="stylesheet">-->


    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-2C0NK0XKWR"></script>
    <script>
     window.dataLayer = window.dataLayer || [];
     function gtag(){dataLayer.push(arguments);}
     gtag('js', new Date());

     gtag('config', 'G-2C0NK0XKWR');
    </script>


    <link rel="preload" href="{{asset('assets/site/styles/stylesheets/main.css')}}" as="style"/>
    <link rel="stylesheet" href="{{asset('assets/site/styles/stylesheets/main.css')}}"/>
    <link rel="stylesheet" href="{{asset('assets/common/css/style.css')}}?v=31211"/>

    <script src="{{asset('assets/site/js/jquery-3.4.1.min.js')}}"></script>

</head>

<body>


<div id="fb-root"></div>
<script async defer crossorigin="anonymous" src="https://connect.facebook.net/en_US/sdk.js#xfbml=1&version=v14.0"
        nonce="4FM6Doqv"></script>

<section class="py-3 p-md-3 sticky-top bg-white border-bottom header">
    <div class="container-fluid">
        <div class="row align-items-center">

            <div class="col-md-12">

		<div class="d-flex justify-content-between">
		     <div class="d-flex align-items-center">

			<a class="navbar-brand me-4 flex-none" href="{{route('site.')}}">
			    <img src="{{asset('assets/site/images/logo/superchef.svg')}}" alt="SuperChef" class="img-fluid">
			</a>

			<div class="navbar-collapse">

			@auth 
			    <div class="mt-3 px-2 px-xl-0 d-xl-none">
				<a href="{{route('logout')}}" class="btn border rounded-pill w-100 border-2">Log out</a>
			    </div>
			@endauth

			    <div class="d-xl-flex align-items-center justify-content-between justify-content-lg-start pt-3 pt-xl-0 px-2 px-xl-0">

				<div class="nav-item">
				    <a class="nav-link d-inline-flex align-items-center" href="/"> Acasă </a>
				</div>

				<div class="nav-item">
				    <a class="nav-link d-inline-flex align-items-center" href="{{route('site.page', 'provocari-active')}}">
					Provocări 
				    </a>
				</div>

				<div class="nav-item">
				    <a class="nav-link {{Utils::getActiveClass('recipe', $current_section ?? '')}}" href="{{route('site.recipes.index')}}"> Rețete </a>
				</div>

				<div class="nav-item">
				    <a class="nav-link {{Utils::getActiveClass('blog', $current_section ?? '')}}" href="{{route('site.articles.index')}}"> Blog </a>
				</div>

				<div class="nav-item d-xl-none">
				   <a class="nav-link" href="{{route('site.page', 'termeni-si-conditii')}}"> Termeni și condiții </a>
				</div>

				<div class="nav-item d-xl-none">
				    <a class="nav-link" href="{{route('site.page', 'politica-de-confidentialitate')}}"> Politica de confidențialitate </a>
				</div>

				<div class="nav-item d-xl-none">
				   <button class="btn nav-link" type="button" data-cc="c-settings" aria-haspopup="dialog">
					Gestionați setările cookie
				    </button>
				</div>

			    </div>

		      </div>
		    </div>

		    <div class="d-flex align-items-center justify-content-end flex-fill">

			<button class="btn search-trigger d-flex align-items-center me-md-3" data-toggle="modal" data-target="#searchModal">
			    <svg class="icon me-md-2"><use xlink:href="#icon-search"></use></svg>
			    <span class="d-none d-md-inline-block">Caută rețete</span>
			</button>

			<a href="{{route('client.')}}"  class="btn rounded-pill border border-2 me-3 d-none d-md-inline-flex hv-bg-gray-300 login-btn flex-none">
			    <span class="d-md-inline fw-700">{{Auth::guest() ? 'Login' : 'Contul meu'}}</span>
			</a>

			@guest
			    <a href="{{route('register')}}" class="btn btn-primary rounded-pill d-none d-md-inline-flex hv-bg-yellow login-btn flex-none me-3">
				<span class="d-md-inline-block fw-700">Cont nou</span>
			    </a>
			@endguest

			<button class="navbar-toggler d-xl-none" type="button" aria-label="Toggle navigation"
				       onclick="$('.navbar-collapse').toggleClass('navbar-visible');$(this).toggleClass('active'); $('body').toggleClass('overlay')">
			    <span class="line top"></span>
			    <span class="line middle"></span>
			    <span class="line bottom"></span>
			</button>
		    </div>
		</div>


            </div>

        </div>
    </div>

</section>

<div class="d-flex d-md-none align-items-center justify-content-between justify-content-lg-start mobile-nav shadow-sm px-3 shadow-md" id="mobile-nav-id">

    <a class="nav-link text-center {{Utils::getActiveClass('home', $current_section ?? '')}}" href="{{route('site.')}}">
	<div class="icon-holder">
	    <svg class="icon fill-black"> <use xlink:href="#icon-home"></use> </svg>
	</div>

	<div>Acasă</div>
    </a>

    <a class="nav-link text-center {{Utils::getActiveClass('provocari-active', $current_section ?? '')}}" href="{{route('site.page', 'provocari-active')}}">
	<div class="icon-holder">
	   <svg class="icon fill-black"> <use xlink:href="#icon-trophy"></use> </svg>
	</div>
	<div>Provocări</div>
    </a>

    <a class="nav-link text-center {{Utils::getActiveClass('recipe', $current_section ?? '')}}" href="{{route('site.recipes.index')}}">
	<div class="icon-holder">
	    <svg class="icon fill-black"> <use xlink:href="#icon-cook-hat"></use> </svg>
	</div>
	<div>Rețete</div>
    </a>

    <a class="nav-link text-center d-none d-sm-block d-md-none {{Utils::getActiveClass('blog', $current_section ?? '')}}" href="{{route('site.articles.index')}}">
	<div class="icon-holder">
	    <svg class="icon fill-black"> <use xlink:href="#icon-book"></use> </svg>
	</div>
	<div>Povești</div>
    </a>

    <a class="nav-link text-center" href="{{route('client.')}}">
	<div class="icon-holder">
	  <svg class="icon fill-black"> <use xlink:href="#icon-user"></use> </svg>
	</div>
	<div>Contul meu</div>
    </a>

</div>



{{--@todo--}}


@if (Session::has('status'))
    <section class="m-0 py-1 alert alert-primary text-center mb-0 rounded-0 text-center" role="alert"
             style="z-index: 2;">
        <p class="my-2 lead">{{Session::get('status')}}</p>
    </section>
@elseif (Session::has('error'))
    <section class="m-0 py-1 alert alert-danger text-center  mb-0 rounded-0 text-center" role="alert"
             style="z-index: 2;">
        <p class="my-2 lead">{{Session::get('error')}}</p>
    </section>
@endif
@if (!empty($errors) && count($errors) > 0)
    <section class="mt-4 alert alert-danger text-center  mb-0 rounded-0 text-center py-4" style="z-index: 2;">
        <h1 class="offset-20 text-danger">Atenție!</h1>
        <ul class="list-unstyled">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </section>
@endif

@yield('content')


<footer>
    <section class="footer bg-secondary pt-5 pb-3">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-12 col-lg-5 col-xl-6 mb-4 mb-lg-0">
                    <img src="{{asset('assets/site/images/logo/superchef.svg')}}" alt="" class="img-fluid footer-logo">
                </div>

                <div class="col-md-12 col-lg-7 col-xl-6">
		    <div class="row">
			<div class="col-sm-6 mb-4 mb-md-0">
			    <ul class="list-unstyled mb-0 footer-menu">
				<li>
				    <a href="{{route('site.')}}"> Acasă </a>
				</li>

                                <li>
				    <a href="#"> Provocări </a>
				</li>

                                <li>
				    <a href="{{route('site.recipes.index')}}"> Rețete </a>
				</li>

                                <li>
				    <a href="{{route('site.articles.index')}}"> Povești din bucătărie </a>
				</li>

                                <li>
				    <a href="{{route('site.page', 'contact')}}"> Contact </a>
				</li>
			    </ul>
			</div>

                        <div class="col-sm-6">
			    <ul class="list-unstyled mb-0 footer-menu">
				<li>
				    <a href="{{route('client.')}}"> Login </a>
				</li>

                                <li>
				    <a href="{{route('register')}}"> Înregistrare </a>
				</li>

                                <li>
				    <a href="{{route('site.page', 'termeni-si-conditii')}}"> Termeni și condiții </a>
				</li>

                                <li>
				    <a href="{{route('site.page', 'politica-de-confidentialitate')}}"> Politica de confidențialitate </a>
				</li>

                                <li>
				    <button class="btn p-0" type="button" data-cc="c-settings" aria-haspopup="dialog">
					Gestionați setările cookie
				    </button>
				</li>
			    </ul>
			</div>

		    </div>

                </div>
            </div>

	    <div class="row g-0 border-top border-gray pt-4 mt-5 fs-14 fw-600">
		<div class="col-md-6 order-2 order-md-1 text-center text-md-start">
		    <span>© {{date('Y')}} {{config('app.name')}}.ro</span>
		</div>

		<div class="col-md-6 text-center text-md-end order-1 order-md-2 mb-2 mb-md-0">
		    <ul class="list-inline footer-socials mb-0">
                        <li class="list-inline-item me-5 me-md-3">
                            <a href="{{config('social.facebook')}}" target="_blank" class="d-flex align-items-center">
				<svg class="icon icon-md fill-black">
				    <use xlink:href="#icon-facebook"></use>
				</svg>
				<span class="ms-1 hv-font-underline">Facebook</span>
                            </a>
                        </li>

                        <li class="list-inline-item mr-2">
                            <a href="{{config('social.instagram')}}" target="_blank" class="d-flex align-items-center">
				<svg class="icon icon-md fill-black">
				    <use xlink:href="#icon-instagram"></use>
				</svg>
                                <span class="ms-1 hv-font-underline">Instagram</span>
                            </a>
                        </li>
                    </ul>
		</div>
	    </div>
        </div>
    </section>
</footer>


<!-- Search Modal -->
<div class="modal fade search-modal" id="searchModal" tabindex="-1" aria-labelledby="search-modal" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">

      <div class="modal-body">
	<div class="search d-flex align-items-center mb-4 mb-mx-5 pb-xl-4">
	    <form action="{{route('site.recipes.index')}}" method="GET" class="d-flex align-items-center search-form">
		<svg class="icon icon-sm fill-gray-600 stroke-1 stroke-gray-600 me-2">
		    <use xlink:href="#icon-search"></use>
		</svg>
		<input name="q" type="text" class="form-control p-0" name="search">
	    </form>

	    <button type="button" class="btn-close ms-3 ms-md-4 p-0" data-dismiss="modal" aria-label="Close">
		<svg class="icon icon-xs fill-black">
		    <use xlink:href="#icon-x"></use>
		</svg>
	    </button>
	</div>
        <div class="fs-24 fw-700 mb-3">Categorii populare</div>

	<div class="search-categories-wrapper">
	    <div class="recipes-categories ms-md-n2">
		@foreach ($all_categories as $category)
		    <a class="btn  " href="{{$category->getUrl()}}">{{$category->name}}</a>
		@endforeach
	    </div>
	</div>

      </div>
    </div>
  </div>
</div>

<!-- Upload photo challenge -->

<div class="modal fade upload-photo" id="challenge-upload-photo" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-body p-4">
	    <div class="text-end mb-3">
		<button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"></button>
	    </div>
	<div class="px-lg-4">
	    <div class="text-center mb-4 mb-xxl-5">
		<div class="fs-36 fw-800 mb-2">Publică o poză</div>
		<div class="fs-20">Publică o poză cu rețeta ta și intră în competiție</div>
	    </div>

            <form>
                <div class="mb-3 input-file border border-2 border-gray-600 rounded-md p-3">
		    <input class="form-control" type="file">

                    <div class="placeholder-file d-flex align-items-center justify-content-center">
                        <svg class="icon icon-sm fill-black fw-700 me-3">
			    <use xlink:href="#icon-arrow-up"></use>
			</svg>

                        <div class="file-name">Încarcă imagine</div>
		    </div>
		</div>

                <div class="border border-2 border-gray-600 rounded-md recipe-desc mb-4">
		    <label class="has-float-label">
			<textarea class="form-control h-auto pt-4 border-0 rounded-md" name="mesaj" rows="4" required="" placeholder="&nbsp;"></textarea>
			<span>Mesajul tău</span>
		    </label>
		</div>

                <div class="bg-gray-100 p-3 rounded-sm d-flex align-items-center mb-4 mb-xl-5">
                    <svg class="icon icon-md fill-black fw-700 me-3 flex-none">
			<use xlink:href="#icon-info"></use>
		    </svg>

                    <div class="fs-15 fw-600">
                        Postarea urmează sa fie aprobată de către echipa Superchef și
                        supusa la votul publicului de pe website. Pentru mai multe detalii puteti consulta
                        Termenii și Conditiile în sețiunea “Provocări”.
                    </div>

		</div>

                <button name="submit" type="submit" class="btn btn-primary btn-custom w-100">
			<span class="px-4 d-inline-block">Publică rețeta</span>
		</button>

	    </form>
	</div>

      </div>
    </div>
  </div>
</div>


<!-- Upload photo challenge -->

<div class="modal fade confirm-vote" id="confirm-vote-modal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-body p-4">
	<div class="text-end mb-3">
	    <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"></button>
	</div>
	<div class="px-lg-4">
	    <div class="text-center mb-4">
		<div class="fs-36 fw-800 mb-2">Confirmă votul</div>
	    </div>

            <button name="submit" type="submit" class="btn btn-primary btn-custom w-100">
		<span class="px-4 d-inline-block">Votează acum</span>
	    </button>
	</div>

      </div>
    </div>
  </div>
</div>

<div class="icons-holder d-none position-absolute pointer-events-none" style="top: 0">
    <svg width="0" height="0">
	<symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="icon-search">
	    <path d="M23,21.4l-4.2-4.2c1.4-1.8,2.2-4,2.2-6.4c0-5.6-4.6-10.2-10.2-10.2C5.2,0.6,0.6,5.2,0.6,10.9c0,5.6,4.6,10.2,10.2,10.2
	c2.4,0,4.6-0.8,6.4-2.2l4.2,4.2c0.2,0.2,0.5,0.3,0.8,0.3s0.6-0.1,0.8-0.3C23.5,22.6,23.5,21.9,23,21.4z M2.9,10.9c0-4.4,3.6-8,8-8
	c4.4,0,8,3.6,8,8c0,2.2-0.9,4.2-2.3,5.6c0,0,0,0,0,0s0,0,0,0c-1.4,1.4-3.4,2.3-5.6,2.3C6.5,18.8,2.9,15.2,2.9,10.9z"></path>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="icon-x">
	    <path d="M14.2,12l8.3-8.3c0.6-0.6,0.6-1.6,0-2.2s-1.6-0.6-2.2,0L12,9.8L3.7,1.5c-0.6-0.6-1.6-0.6-2.2,0s-0.6,1.6,0,2.2L9.8,12
	l-8.3,8.3c-0.6,0.6-0.6,1.6,0,2.2C1.8,22.8,2.2,23,2.6,23s0.8-0.2,1.1-0.5l8.3-8.3l8.3,8.3c0.3,0.3,0.7,0.5,1.1,0.5
	c0.4,0,0.8-0.2,1.1-0.5c0.6-0.6,0.6-1.6,0-2.2L14.2,12z"></path>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="icon-instagram">
	    <g>
		<g>
			<path d="M17,23H7c-3.3,0-6-2.7-6-6V7c0-3.3,2.7-6,6-6h10c3.3,0,6,2.7,6,6v10C23,20.3,20.3,23,17,23z M7,3C4.8,3,3,4.8,3,7v10
				c0,2.2,1.8,4,4,4h10c2.2,0,4-1.8,4-4V7c0-2.2-1.8-4-4-4H7z"/>
		</g>
		<g>
			<path d="M12,17c-2.4,0-4.6-1.8-4.9-4.3C6.7,10,8.6,7.4,11.3,7c0.5-0.1,1-0.1,1.5,0c2.2,0.3,3.9,2,4.2,4.2l0,0
				c0.2,1.3-0.1,2.6-0.9,3.7c-0.8,1.1-2,1.8-3.3,2C12.5,16.9,12.3,17,12,17z M12,9c-0.1,0-0.3,0-0.4,0c-1.6,0.2-2.8,1.8-2.5,3.4
				c0.2,1.6,1.8,2.8,3.4,2.5c0.8-0.1,1.5-0.5,2-1.2s0.7-1.4,0.6-2.2l0,0c-0.2-1.3-1.2-2.3-2.5-2.5C12.3,9,12.2,9,12,9z"/>
		</g>
		<g>
			<path d="M17.5,7.5c-0.6,0-1-0.4-1-1s0.4-1,1-1h0c0.6,0,1,0.4,1,1S18.1,7.5,17.5,7.5z"/>
		</g>
	    </g>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="icon-facebook">
	    <path d="M14,23h-4c-0.6,0-1-0.4-1-1v-7H7c-0.6,0-1-0.4-1-1v-4c0-0.6,0.4-1,1-1h2V7c0-3.3,2.7-6,6-6h3c0.6,0,1,0.4,1,1v4
		c0,0.6-0.4,1-1,1h-3v2h3c0.3,0,0.6,0.1,0.8,0.4S19,9.9,19,10.2l-1,4c-0.1,0.4-0.5,0.8-1,0.8h-2v7C15,22.6,14.6,23,14,23z M11,21h2
		v-7c0-0.6,0.4-1,1-1h2.2l0.5-2H14c-0.6,0-1-0.4-1-1V7c0-1.1,0.9-2,2-2h2V3h-2c-2.2,0-4,1.8-4,4v3c0,0.6-0.4,1-1,1H8v2h2
		c0.6,0,1,0.4,1,1V21z"/>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="icon-home">
	    <path d="M21.6,8.2l-9-7c-0.4-0.3-0.9-0.3-1.2,0l-9,7C2.1,8.4,2,8.7,2,9v11c0,1.7,1.3,3,3,3h14c1.7,0,3-1.3,3-3V9
		    C22,8.7,21.9,8.4,21.6,8.2z M14,21h-4v-8h4V21z M20,20c0,0.6-0.4,1-1,1h-3v-9c0-0.6-0.4-1-1-1H9c-0.6,0-1,0.4-1,1v9H5
		    c-0.6,0-1-0.4-1-1V9.5l8-6.2l8,6.2V20z"/>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 25" id="icon-trophy">
		<path d="M18.7,3.6v-1c0-0.7-0.5-1.2-1.2-1.2h-11c-0.7,0-1.2,0.5-1.2,1.2v1c-1.5,0-4.4,0.1-4.4,3.2c0,2.7,2.2,6.7,5.3,6.9
	    c1,1.7,2.7,2.8,4.6,3.2v4.3H7.6c-0.7,0-1.2,0.5-1.2,1.2c0,0.7,0.5,1.2,1.2,1.2h8.8c0.7,0,1.2-0.5,1.2-1.2c0-0.7-0.5-1.2-1.2-1.2
	    h-3.2v-4.3c1.9-0.3,3.5-1.5,4.6-3.2c3.2-0.3,5.3-4.3,5.3-6.9C23.1,4.1,21,3.6,18.7,3.6z M20.7,6.9c-0.1,1-0.7,2.9-2,3.9V6
	    c0.8,0,1.6,0,1.9,0.3C20.6,6.4,20.7,6.5,20.7,6.9z M7.7,10.3V3.8h8.5v6.5c0,1.1-0.4,2.2-1.3,3c-0.8,0.8-1.9,1.3-3,1.3
	    c-1.1,0-2.2-0.4-3-1.3C8.2,12.5,7.7,11.4,7.7,10.3z M5.3,6v4.7C4.1,9.8,3.4,8,3.3,7c0-0.4,0-0.6,0.1-0.6C3.7,6.1,4.5,6,5.3,6z"/>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="icon-user">
	   <g>
		<g>
			<path d="M21,23.2c-0.6,0-1.1-0.5-1.1-1.1v-2.2c0-1.9-1.5-3.4-3.4-3.4h-9c-1.9,0-3.4,1.5-3.4,3.4v2.2c0,0.6-0.5,1.1-1.1,1.1
				s-1.1-0.5-1.1-1.1v-2.2c0-3.1,2.5-5.6,5.6-5.6h9c3.1,0,5.6,2.5,5.6,5.6v2.2C22.1,22.7,21.6,23.2,21,23.2z"/>
		</g>
		<g>
			<path d="M12,12c-3.1,0-5.6-2.5-5.6-5.6S8.9,0.8,12,0.8s5.6,2.5,5.6,5.6S15.1,12,12,12z M12,3c-1.9,0-3.4,1.5-3.4,3.4
				s1.5,3.4,3.4,3.4s3.4-1.5,3.4-3.4S13.9,3,12,3z"/>
		</g>
	    </g>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="icon-menu">
	    <g>
		<path d="M21.9,13.1H2.1C1.5,13.1,1,12.6,1,12c0-0.6,0.5-1.1,1.1-1.1h19.7c0.6,0,1.1,0.5,1.1,1.1C23,12.6,22.5,13.1,21.9,13.1z"/>
	    </g>
	    <g>
		<path d="M21.9,6.5H2.1C1.5,6.5,1,6,1,5.4s0.5-1.1,1.1-1.1h19.7c0.6,0,1.1,0.5,1.1,1.1S22.5,6.5,21.9,6.5z"/>
	    </g>
	    <g>
		<path d="M21.9,19.7H2.1c-0.6,0-1.1-0.5-1.1-1.1s0.5-1.1,1.1-1.1h19.7c0.6,0,1.1,0.5,1.1,1.1S22.5,19.7,21.9,19.7z"/>
	    </g>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="1 0 25 24" id="icon-facebook-circle">
		<path d="M25,12.1c0-6.4-5.2-11.5-11.5-11.5C7.1,0.5,2,5.7,2,12.1c0,5.8,4.2,10.5,9.7,11.4v-8.1H8.8v-3.3
		h2.9V9.5c0-2.9,1.7-4.5,4.4-4.5c1.3,0,2.6,0.2,2.6,0.2v2.8h-1.5c-1.4,0-1.9,0.9-1.9,1.8v2.2h3.2L18,15.4h-2.7v8.1
		C20.8,22.6,25,17.8,25,12.1z"/>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="icon-google">
		<g>
		    <path class="st0" style="fill:#4285F4;" d="M19.7,20.4c2.1-1.9,3.3-4.8,3.3-8.2c0-0.8-0.1-1.5-0.2-2.3H12.2v4.3h6.1c-0.3,1.4-1.1,2.6-2.2,3.4v0
			    c0,0,0,0,0,0L19.7,20.4z"/>
		    <path class="st1" style="fill:#34A853;" d="M16,17.7C16,17.7,16,17.7,16,17.7c-1,0.7-2.3,1.1-3.8,1.1c-2.9,0-5.4-2-6.3-4.6h0c0,0,0,0,0,0L2.2,17
			    c1.9,3.8,5.8,6.1,10,6.1c3,0,5.6-1,7.4-2.7l0,0L16,17.7z"/>
		    <path class="st2" style="fill:#FBBC04;" d="M5.9,14.1c-0.5-1.4-0.5-2.9,0-4.3v0L2.2,7h0c-1.6,3.1-1.6,6.8,0,10l0,0L5.9,14.1C5.9,14.1,5.9,14.1,5.9,14.1z"
			    />
		    <path class="st3" style="fill:#EA4335;" d="M5.9,9.9c0.9-2.6,3.4-4.6,6.3-4.6c1.6,0,3.1,0.6,4.3,1.7l3.2-3.2c-2-1.9-4.7-2.9-7.5-2.9C8,0.9,4.1,3.2,2.2,7
			    l0,0L5.9,9.9L5.9,9.9z"/>
		</g>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="icon-eye">
		<g>
		    <path d="M12,21c-7.5,0-11.7-8.2-11.9-8.6c-0.1-0.3-0.1-0.6,0-0.9C0.3,11.2,4.5,3,12,3s11.7,8.2,11.9,8.6c0.1,0.3,0.1,0.6,0,0.9
			C23.7,12.8,19.5,21,12,21z M2.1,12c0.9,1.6,4.5,7,9.9,7c5.4,0,8.9-5.4,9.9-7c-0.9-1.6-4.5-7-9.9-7C6.6,5,3.1,10.4,2.1,12z"/>
		</g>

		<g>
		    <path d="M12,16c-2.2,0-4-1.8-4-4c0-2.2,1.8-4,4-4c2.2,0,4,1.8,4,4C16,14.2,14.2,16,12,16z M12,10c-1.1,0-2,0.9-2,2c0,1.1,0.9,2,2,2
		    c1.1,0,2-0.9,2-2C14,10.9,13.1,10,12,10z"/>
		</g>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="-895 -29 128 128" id="icon-waving-hand">
	    <g>
		<g>
			<path class="st0" style="fill:#FFCA28" d="M-877.4,33.7c-2.8-4-3.9-7.8-1.2-10.1c2.3-1.9,5.7-2.3,9.9,2.5c0,0,12.5,14.6,16.9,18.6
				c1,0.9,2.2,1.1,3.3-0.1c0.9-1,0.6-1.8-0.2-3c0,0-17.7-26.3-20-29.5c-3.9-5.4-2.4-8.8-0.6-10.5c2.5-2.3,6.9-2.8,10.9,2.8l21.4,28.7
				c0.7,0.7,1.7,0.8,2.5,0.3c0.1-0.1,0.2-0.1,0.3-0.2c0.8-0.6,1-1.6,0.5-2.5c-3.8-6.5-18.7-32.5-20.9-37.3c-2.5-5.5-1.4-8.3,1.2-9.9
				c3.2-1.9,6.2-1.8,9.7,3.5c3.9,5.8,18.9,30,22.7,36.5c0.5,0.8,1.6,1.2,2.5,0.7c0,0,0,0,0,0c0.8-0.4,1.6-1.2,1.3-2.4
				c-2.1-6.9-12.3-28.2-14.4-33.1c-2.9-6.7-1.5-9,1.5-10.5c3.2-1.6,6.5-0.3,8.7,4.1c1.5,3,28.2,51.6,28.2,51.6
				c-0.4-7.2,1.4-12.4,3-17.5c2.8-9.4,9.7-14.2,14.7-12c2.6,1.1,3.1,3.4,2.8,5.2c-0.6,3.4-2.9,13.9-3.4,22
				c-1.1,19.2,4.7,41.4-16.9,55.3c-14.5,9.3-30,7.7-40.3,0.5C-845.7,78.8-875.2,37-877.4,33.7z"/>
			<path class="st1" style="fill:#EDA600" d="M-777.3,22.8c-1.8,7.6-2,17-2,20.9c0.2,15.5,0.2,28.9-15.4,41.2c-1.9,1.5-7.9,5.2-14.9,7.1
				c-2.2,0.6-1.4,1.3,0,1.2c7.6-0.9,13.4-4.2,16.6-6.2c21.6-13.9,16.3-35.9,17.4-55.1c0.5-8.2,3-21.1,2.9-22.2
				C-772.7,8.5-775.5,15.2-777.3,22.8z"/>
			<path class="st1" style="fill:#EDA600" d="M-817.5,23.6c0,0-1.6,0-3-2c-4.4-6.1-18.2-29.3-22.2-35c-4.5-6.5-8.8-4-9.7-3.5c0,0,3.5,0.1,5.4,3
				c3.9,5.8,18.8,31.8,23.5,37.4C-820.5,27.1-817.5,23.6-817.5,23.6z"/>
			<path class="st1" style="fill:#EDA600" d="M-872.3,25.5c1.4,1.5,13.3,15.6,17.7,19.6c3.8,3.4,6.6-0.9,6.6-0.9s-1.4,0.2-3.3-1.2
				c-4.7-3.6-15.9-16.3-18.4-19c-3.7-4-7.2-1.5-8-1C-877.7,22.9-875.5,22.1-872.3,25.5z"/>
			<path class="st1" style="fill:#EDA600" d="M-833.4,32.3c0,0-1.3,0.9-3.6-1.8c-1.7-2-21.3-26-21.3-26c-4.9-6-8.8-4.2-9.6-3.8c0,0,2.5-0.1,5.4,3.2
				c1.3,1.5,22.3,28.2,23.1,29.1C-836.4,36.4-833.6,33.5-833.4,32.3z"/>
			<path class="st1" style="fill:#EDA600" d="M-793.2,28.8c0,0-26-43.6-27.7-46.6c-3.7-6.6-8-4.6-8.7-4.2c0,0,2.4-0.7,5.2,4.1c1.5,2.5,20.6,36.9,26.7,47.9
				c0.5,2,0.4,4.7-1.1,6.4c-5.5,6.2-12.6,12.5-10.5,28.2c0.5,4,2,7.7,3.1,9.5c1.4,2.3,3,1.4,2.3-0.3c-0.5-1.2-1.2-3.9-1.4-5
				c-0.7-5.4-3.1-14.8,7.5-26.2C-796,40.8-791.4,35.1-793.2,28.8z"/>
		</g>
		<g>
			<path class="st2" style="fill:#B0BEC5" d="M-791.5,2c-1.4-4.9-3.5-9.5-6.3-13.4c-2.5-3.5-5.6-6.6-9.1-9c-0.4-0.3-1-1.3-0.5-2.2c0.5-0.9,1.5-0.8,1.9-0.7
				c4.4,1.8,7.9,4.9,10.9,9.1c3.5,5,5.2,9.8,6.1,15.1c0.1,0.6,0.1,1.8-1.2,2.1C-791,3.4-791.4,2.4-791.5,2z"/>
		</g>
		<g>
			<path class="st2" style="fill:#B0BEC5" d="M-798.3,7.3c-1.4-4.9-3.5-9.5-6.3-13.4c-2.5-3.5-5.6-6.6-9.1-9c-0.4-0.3-1-1.3-0.5-2.2
				c0.5-0.9,1.5-0.8,1.9-0.7c4.4,1.8,7.9,4.9,10.9,9.1c3.5,5,5.2,9.8,6.1,15.1c0.1,0.6,0.1,1.8-1.2,2.1
				C-797.7,8.7-798.2,7.7-798.3,7.3z"/>
		</g>
		<g>
			<path class="st2" style="fill:#B0BEC5" d="M-886.4,48.5c1.7,4.8,4.2,9.2,7.2,12.9c2.8,3.3,6,6.2,9.6,8.4c0.5,0.3,1.1,1.2,0.7,2.2
				c-0.4,1-1.5,0.9-1.9,0.8c-4.5-1.5-8.2-4.3-11.4-8.4c-3.8-4.8-5.9-9.4-7.1-14.7c-0.1-0.6-0.2-1.8,1-2.2
				C-887.1,47.1-886.6,48-886.4,48.5z"/>
		</g>
		<g>
			<path class="st2" style="fill:#B0BEC5" d="M-880,42.7c1.7,4.8,4.2,9.2,7.2,12.9c2.8,3.3,6,6.2,9.6,8.4c0.5,0.3,1.1,1.2,0.7,2.2c-0.4,1-1.5,0.9-1.9,0.8
				c-4.5-1.5-8.2-4.3-11.4-8.4c-3.8-4.8-5.9-9.4-7.1-14.7c-0.1-0.6-0.2-1.8,1-2.2C-880.7,41.3-880.2,42.3-880,42.7z"/>
		</g>
	    </g>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="icon-arrow-right">
	    <path d="M23.4,11.2L12.8,0.6c-0.4-0.4-1.2-0.4-1.6,0c-0.4,0.4-0.4,1.2,0,1.6l8.7,8.7H1.4c-0.6,0-1.1,0.5-1.1,1.1s0.5,1.1,1.1,1.1
		    h18.5l-8.7,8.7c-0.4,0.4-0.4,1.2,0,1.6c0.2,0.2,0.5,0.3,0.8,0.3s0.6-0.1,0.8-0.3l10.6-10.6C23.8,12.4,23.8,11.6,23.4,11.2z"/>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="icon-arrow-left">
	    <path d="M0.6,12.8l10.6,10.6c0.4,0.4,1.2,0.4,1.6,0c0.4-0.4,0.4-1.2,0-1.6l-8.7-8.7h18.5c0.6,0,1.1-0.5,1.1-1.1s-0.5-1.1-1.1-1.1
		     H4.1l8.7-8.7c0.4-0.4,0.4-1.2,0-1.6c-0.2-0.2-0.5-0.3-0.8-0.3s-0.6,0.1-0.8,0.3L0.6,11.2C0.2,11.6,0.2,12.4,0.6,12.8z"/>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="icon-arrow-up">
	    <path d="M22.2,11.1l-9.3-9.3c-0.1-0.1-0.3-0.2-0.4-0.3c-0.3-0.1-0.7-0.1-1,0c-0.2,0.1-0.3,0.2-0.4,0.3l-9.3,9.3
		    c-0.5,0.5-0.5,1.4,0,1.9c0.5,0.5,1.4,0.5,1.9,0l7-7v15.4c0,0.7,0.6,1.3,1.3,1.3c0.7,0,1.3-0.6,1.3-1.3V5.9l7,7
		    c0.3,0.3,0.6,0.4,0.9,0.4c0.3,0,0.7-0.1,0.9-0.4C22.8,12.4,22.8,11.6,22.2,11.1z"/>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="icon-arrow-down">
	    <path d="M1.8,12.9l9.3,9.3c0.1,0.1,0.3,0.2,0.4,0.3c0.3,0.1,0.7,0.1,1,0c0.2-0.1,0.3-0.2,0.4-0.3l9.3-9.3c0.5-0.5,0.5-1.4,0-1.9
		    c-0.5-0.5-1.4-0.5-1.9,0l-7,7V2.7c0-0.7-0.6-1.3-1.3-1.3c-0.7,0-1.3,0.6-1.3,1.3v15.4l-7-7c-0.3-0.3-0.6-0.4-0.9-0.4
		    S2,10.8,1.8,11.1C1.2,11.6,1.2,12.4,1.8,12.9z"/>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="-947 24 24 24" id="icon-award">
	    <path d="M-927.6,32.3c0-4.1-3.3-7.4-7.4-7.4s-7.4,3.3-7.4,7.4c0,2.4,1.1,4.5,2.9,5.9l-1,7.9c0,0.4,0.1,0.7,0.4,0.9
	c0.3,0.2,0.7,0.2,1,0l4.2-2.5l4.2,2.5c0.1,0.1,0.3,0.1,0.5,0.1c0.2,0,0.4-0.1,0.5-0.2c0.3-0.2,0.5-0.5,0.4-0.9l-1-7.9
	C-928.7,36.8-927.6,34.7-927.6,32.3z M-940.6,32.3c0-3.1,2.5-5.6,5.6-5.6s5.6,2.5,5.6,5.6c0,3.1-2.5,5.6-5.6,5.6
	S-940.6,35.4-940.6,32.3z M-931.5,44.4l-3-1.8c-0.3-0.2-0.7-0.2-1,0l-3,1.8l0.7-5.2c0.9,0.3,1.8,0.5,2.8,0.5c1,0,1.9-0.2,2.8-0.5
	L-931.5,44.4z"/>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="-947 24 24 24" id="icon-clock">
	    <g>
		<path d="M-935,47c-6.1,0-11-4.9-11-11s4.9-11,11-11s11,4.9,11,11S-928.9,47-935,47z M-935,27c-5,0-9,4-9,9c0,5,4,9,9,9c5,0,9-4,9-9
		C-926,31-930,27-935,27z"/>
	    </g>

	    <g>
		<path d="M-931,39c-0.2,0-0.3,0-0.4-0.1l-4-2c-0.3-0.2-0.6-0.5-0.6-0.9v-6c0-0.6,0.4-1,1-1s1,0.4,1,1v5.4l3.4,1.7
		c0.5,0.2,0.7,0.8,0.4,1.3C-930.3,38.8-930.6,39-931,39z"/>
	    </g>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="-947 24 24 24" id="icon-chevron-down">
	   <path d="M-924.2,30.3c-0.4-0.4-1-0.4-1.4,0l-9.4,9.4l-9.4-9.4c-0.4-0.4-1-0.4-1.4,0s-0.4,1,0,1.4l10.1,10.1c0.2,0.2,0.4,0.3,0.7,0.3
		s0.5-0.1,0.7-0.3l10.1-10.1C-923.8,31.3-923.8,30.6-924.2,30.3z"/>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="-946 23 26 26" id="icon-camera">
	    <path class="st1" d="M-921.7,30.1c-0.4-0.4-1-0.6-1.5-0.6h-4.3l-2.2-3.3h-6.5l-2.2,3.3h-4.3c-0.6,0-1.1,0.2-1.5,0.6c-0.4,0.4-0.6,1-0.6,1.5v11.9
	     c0,0.6,0.2,1.1,0.6,1.5c0.4,0.4,1,0.6,1.5,0.6h19.5c0.6,0,1.1-0.2,1.5-0.6c0.4-0.4,0.6-1,0.6-1.5V31.7
	     C-921.1,31.1-921.3,30.5-921.7,30.1z M-933,41.6c-2.6,0-4.7-2.1-4.7-4.7s2.1-4.7,4.7-4.7c2.6,0,4.7,2.1,4.7,4.7
	     S-930.4,41.6-933,41.6z"/>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="-947 24 24 24" id="icon-check">
	   <path d="M-924.2,27.8c-0.5-0.5-1.3-0.5-1.8,0l-12.8,12.8l-5.3-5.3c-0.5-0.5-1.3-0.5-1.8,0c-0.5,0.5-0.5,1.3,0,1.8l6.2,6.2
	c0.2,0.2,0.6,0.4,0.9,0.4s0.6-0.1,0.9-0.4l13.6-13.6C-923.7,29.1-923.7,28.3-924.2,27.8z"/>
	</symbol>


        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="-947 24 24 24" id="icon-message-circle">
	   <path d="M-925,34.9c-0.3-4.8-4.1-8.7-9-8.9h-0.5c0,0,0,0,0,0c-1.5,0-2.9,0.3-4.2,1c-3.2,1.6-5.3,4.9-5.3,8.5c0,1.3,0.3,2.7,0.8,3.9
		l-1.8,5.3c-0.1,0.4,0,0.8,0.2,1c0.2,0.2,0.4,0.3,0.7,0.3c0.1,0,0.2,0,0.3-0.1l5.3-1.8c1.2,0.5,2.5,0.8,3.9,0.8c3.6,0,6.9-2,8.5-5.2
		c0.7-1.3,1-2.8,1-4.3L-925,34.9z M-927,35.5C-927,35.5-927,35.5-927,35.5c0,1.2-0.3,2.3-0.8,3.4c-1.3,2.6-3.8,4.1-6.7,4.1
		c-1.2,0-2.3-0.3-3.3-0.8c-0.2-0.1-0.5-0.1-0.8-0.1l-3.8,1.3l1.3-3.8c0.1-0.3,0.1-0.5-0.1-0.8c-0.5-1-0.8-2.2-0.8-3.3
		c0-2.9,1.6-5.4,4.2-6.7c1-0.5,2.2-0.8,3.3-0.8c0,0,0,0,0,0l0.4,0c3.8,0.2,6.8,3.2,7.1,7V35.5z"/>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 19" id="icon-verified">
	   <path fill="#7EBCFD" d="M8.438 1.628a1.084 1.084 0 0 0-1.446.431l-.522.942a1.078 1.078 0 0 1-.84.549l-1.066.102a1.069 1.069 0 0 0-.971 1.126l.072 1.14c.022.343-.126.675-.395.892l-.873.702c-.44.354-.527.986-.197 1.443l.693.962c.198.274.252.624.148.945l-.366 1.115c-.173.53.097 1.104.62 1.314l1.075.432c.318.127.556.397.64.726l.288 1.134c.14.55.693.896 1.256.785l1.07-.21c.346-.068.704.035.958.277l.807.767a1.087 1.087 0 0 0 1.506-.011l.759-.744c.254-.25.617-.357.968-.289l1.049.204a1.078 1.078 0 0 0 1.26-.814l.242-1.08c.076-.34.316-.623.642-.755l1.01-.411a1.06 1.06 0 0 0 .605-1.34l-.395-1.102a1.054 1.054 0 0 1 .125-.955l.653-.948a1.056 1.056 0 0 0-.22-1.433l-.93-.729a1.06 1.06 0 0 1-.407-.867l.038-1.18a1.07 1.07 0 0 0-.973-1.094l-1.12-.107a1.078 1.078 0 0 1-.829-.527l-.579-.988a1.085 1.085 0 0 0-1.44-.407l-.944.498a1.09 1.09 0 0 1-1.008.003l-.963-.498Zm-1.37 6.869 2.081 2.056 4.164-4.113 1.04 1.029L9.15 12.61 6.027 9.525l1.04-1.028Z"/>
	</symbol>


        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="-947 24 24 24" id="icon-send">
	   <path d="M-924.2,36.7c0.1-0.1,0.1-0.1,0.2-0.2c0,0,0-0.1,0-0.1c0-0.1,0.1-0.2,0.1-0.4c0-0.1,0-0.2-0.1-0.4c0,0,0-0.1,0-0.1
	    c0-0.1-0.1-0.2-0.2-0.2c0,0,0,0-0.1-0.1c-0.1-0.1-0.2-0.1-0.3-0.2l-20.1-9.7c-0.4-0.2-0.9-0.1-1.2,0.2c-0.3,0.3-0.4,0.7-0.3,1.2
	    l3.6,9.3l-3.6,9.3c-0.1,0.4-0.1,0.8,0.2,1.1c0,0,0,0,0,0c0.3,0.3,0.8,0.4,1.2,0.2l20.1-9.7C-924.4,36.9-924.3,36.8-924.2,36.7
	    C-924.2,36.7-924.2,36.7-924.2,36.7z M-929.6,34.9h-11l-2.5-6.5L-929.6,34.9z M-943.1,43.6l2.5-6.5h11.1L-943.1,43.6z"/>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="16 -15 55 55" id="icon-trophy-color">
	 <g>
	    <path class="st0" style="fill:none;" d="M21.4-3.3c0,0,2.2,9.7,2.4,11.2c0.3,1.5,1.4,3.1,3.1,3.1h4.9C28.9,5.7,26.9-0.3,26.9-5c0-0.9,0-1.7,0.1-2.4
		    h-3.1C22.1-7.4,20.9-6.2,21.4-3.3z"/>
	    <path class="st0" style="fill:none;" d="M55.6,11h4.6c1.7,0,2.8-1.6,3.1-3.1c0.3-1.5,2.4-11.2,2.4-11.2c0.5-2.9-0.7-4.1-2.4-4.1h-2.8
		    c0,0.7,0.1,1.5,0.1,2.4C60.5-0.3,58.4,5.7,55.6,11z"/>
	    <path class="st1" style="fill:#FFAC33;" d="M71-7.3c-0.4-2.8-2.4-4.7-4.7-4.7h-6.6c0.4,1.1,0.7,2.6,0.8,4.6h2.8c1.7,0,2.9,1.1,2.4,4.1
		    c0,0-2.2,9.7-2.4,11.2C63,9.4,61.9,11,60.2,11h-4.6c-0.9,1.6-1.8,3.2-2.8,4.6h9.3c3,0,5.6-2.3,6.1-4.6c0.2-0.9,2.7-15.3,2.7-15.3
		    c0-0.2,0.1-0.4,0.1-0.6V-7.3z"/>
	    <path class="st1" style="fill:#FFAC33;" d="M39,20.6c-0.3,4.7-1.6,8.1-2.8,10.2h14.4c-1.2-2.1-2.4-5.4-2.7-9.9c-1.5,1.2-2.9,1.9-4.2,1.9
		    C42.3,22.8,40.7,22,39,20.6z"/>
	    <path class="st1" style="fill:#FFAC33;" d="M26.9,11c-1.7,0-2.8-1.6-3.1-3.1c-0.3-1.5-2.4-11.2-2.4-11.2c-0.5-2.9,0.7-4.1,2.4-4.1h3.1
		    c0.1-2,0.4-3.5,0.7-4.6h-6.9c-3.1,0-5.5,3.2-4.6,7.6c0,0,2.7,14.3,2.9,15.2c0.5,2.4,3.2,4.6,6.2,4.6h9.3c-1-1.4-2-3-2.8-4.6H26.9z"
		    />
	    <path class="st2" style="fill:#FFD12B;" d="M60.5-5c0-0.9,0-1.7-0.1-2.4c-0.1-2-0.3-3.5-0.8-4.6c-0.9-2.3-2.6-2.7-5.3-2.7l-10.7,0c-3,0-10.1,0-12.2,0
		    c-1.8,0-3,0.6-3.8,2.7c-0.4,1.1-0.6,2.6-0.7,4.6c0,0.7-0.1,1.5-0.1,2.4c0,4.6,2.1,10.7,4.9,15.9c0.9,1.6,1.8,3.2,2.8,4.6
		    c1.4,2,2.9,3.8,4.4,5c1.6,1.4,3.2,2.2,4.6,2.2c1.3,0,2.7-0.7,4.2-1.9c1.6-1.3,3.3-3.2,4.8-5.4c1-1.4,2-3,2.8-4.6
		    C58.4,5.7,60.5-0.3,60.5-5z"/>
	    <path class="st3" style="fill:#FF7816;" d="M33.1,30.8c-1.6,0-3.4,1.4-3.4,3.1v1.5v0H29c-1.2,0-2.3,0.9-2.3,2.1v0.4c0,1.2,0.3,2.1,2.3,2.1h29.4
		    c2.2,0,1.9-0.9,1.9-2.1v-0.4c0-1.2-0.8-2.1-1.9-2.1h-1.1v0v-1.5c0-1.7-1.3-3.1-2.9-3.1h-3.7H36.3H33.1z"/>
	</g>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="16 -15 55 55" id="icon-trophy-solid">
	 <g>
	    <path class="st0" style="fill:none;" d="M21.4-3.3c0,0,2.2,9.7,2.4,11.2c0.3,1.5,1.4,3.1,3.1,3.1h4.9C28.9,5.7,26.9-0.3,26.9-5c0-0.9,0-1.7,0.1-2.4
		    h-3.1C22.1-7.4,20.9-6.2,21.4-3.3z"/>
	    <path class="st0" style="fill:none;" d="M55.6,11h4.6c1.7,0,2.8-1.6,3.1-3.1c0.3-1.5,2.4-11.2,2.4-11.2c0.5-2.9-0.7-4.1-2.4-4.1h-2.8
		    c0,0.7,0.1,1.5,0.1,2.4C60.5-0.3,58.4,5.7,55.6,11z"/>
	    <path class="st1" d="M71-7.3c-0.4-2.8-2.4-4.7-4.7-4.7h-6.6c0.4,1.1,0.7,2.6,0.8,4.6h2.8c1.7,0,2.9,1.1,2.4,4.1
		    c0,0-2.2,9.7-2.4,11.2C63,9.4,61.9,11,60.2,11h-4.6c-0.9,1.6-1.8,3.2-2.8,4.6h9.3c3,0,5.6-2.3,6.1-4.6c0.2-0.9,2.7-15.3,2.7-15.3
		    c0-0.2,0.1-0.4,0.1-0.6V-7.3z"/>
	    <path class="st1" d="M39,20.6c-0.3,4.7-1.6,8.1-2.8,10.2h14.4c-1.2-2.1-2.4-5.4-2.7-9.9c-1.5,1.2-2.9,1.9-4.2,1.9
		    C42.3,22.8,40.7,22,39,20.6z"/>
	    <path class="st1" d="M26.9,11c-1.7,0-2.8-1.6-3.1-3.1c-0.3-1.5-2.4-11.2-2.4-11.2c-0.5-2.9,0.7-4.1,2.4-4.1h3.1
		    c0.1-2,0.4-3.5,0.7-4.6h-6.9c-3.1,0-5.5,3.2-4.6,7.6c0,0,2.7,14.3,2.9,15.2c0.5,2.4,3.2,4.6,6.2,4.6h9.3c-1-1.4-2-3-2.8-4.6H26.9z"
		    />
	    <path class="st2" d="M60.5-5c0-0.9,0-1.7-0.1-2.4c-0.1-2-0.3-3.5-0.8-4.6c-0.9-2.3-2.6-2.7-5.3-2.7l-10.7,0c-3,0-10.1,0-12.2,0
		    c-1.8,0-3,0.6-3.8,2.7c-0.4,1.1-0.6,2.6-0.7,4.6c0,0.7-0.1,1.5-0.1,2.4c0,4.6,2.1,10.7,4.9,15.9c0.9,1.6,1.8,3.2,2.8,4.6
		    c1.4,2,2.9,3.8,4.4,5c1.6,1.4,3.2,2.2,4.6,2.2c1.3,0,2.7-0.7,4.2-1.9c1.6-1.3,3.3-3.2,4.8-5.4c1-1.4,2-3,2.8-4.6
		    C58.4,5.7,60.5-0.3,60.5-5z"/>
	    <path class="st3" d="M33.1,30.8c-1.6,0-3.4,1.4-3.4,3.1v1.5v0H29c-1.2,0-2.3,0.9-2.3,2.1v0.4c0,1.2,0.3,2.1,2.3,2.1h29.4
		    c2.2,0,1.9-0.9,1.9-2.1v-0.4c0-1.2-0.8-2.1-1.9-2.1h-1.1v0v-1.5c0-1.7-1.3-3.1-2.9-3.1h-3.7H36.3H33.1z"/>
	</g>
	</symbol>

        <symbol xmlns="http://www.w3.org/2000/svg" viewBox=" 0 0 24 24" id="icon-info">
	    <g>
		<path d="M12,23C5.9,23,1,18.1,1,12S5.9,1,12,1s11,4.9,11,11S18.1,23,12,23z M12,3c-5,0-9,4-9,9c0,5,4,9,9,9c5,0,9-4,9-9
			C21,7,17,3,12,3z"/>
	    </g>
	    <g> <path d="M12,17c-0.6,0-1-0.4-1-1v-4c0-0.6,0.4-1,1-1c0.6,0,1,0.4,1,1v4C13,16.6,12.6,17,12,17z"/> </g>
	    <g> <path d="M12,9c-0.6,0-1-0.4-1-1s0.4-1,1-1h0c0.6,0,1,0.4,1,1S12.6,9,12,9z"/></g>
	</symbol>


        <symbol xmlns="http://www.w3.org/2000/svg" viewBox=" 0 0 24 24" id="icon-book">
	    <path d="M20,1H6.5C4.6,1,3,2.6,3,4.5v15C3,21.4,4.6,23,6.5,23H20c0.6,0,1-0.4,1-1V2C21,1.4,20.6,1,20,1z M6.5,3H19v13H6.5
		c-0.5,0-1,0.1-1.5,0.4V4.5C5,3.7,5.7,3,6.5,3z M6.5,21C5.7,21,5,20.3,5,19.5S5.7,18,6.5,18H19v3H6.5z"/>
	</symbol>


        <symbol xmlns="http://www.w3.org/2000/svg" viewBox=" 0 0 24 24" id="icon-cook-hat">
	    <path d="M23.7,10l0-0.2c-0.4-2.7-2.6-4.7-5.4-4.7C16.9,3,14.5,1.8,12,1.8C9.5,1.8,7.1,3,5.7,5.1c-1.6,0-3,0.6-4,1.8
	c-0.7,0.8-1.2,1.8-1.3,3l0,1.4c0.1,1.2,0.6,2.3,1.2,3.2c0.9,1.2,2,2,3.5,2.6c0,0.8,0,1.7,0,2.5l0,0.7c0,1.1,0.7,1.9,1.9,1.9h10.1
	c1.1,0,1.9-0.7,1.9-1.9v-0.2c0-1,0-2,0-3c0.4-0.2,0.8-0.3,1.2-0.6c1.8-1,2.9-2.5,3.4-4.3c0.1-0.3,0.1-0.5,0.1-0.8l0.1-0.4L23.7,10z
	 M16.9,17.4l0,2.8l-9.8,0v-2.8H16.9z M18.9,13.4c0.2-0.6-0.1-1.2-0.7-1.3c-0.5-0.1-1.1,0.2-1.2,0.8c-0.3,1.1-1,1.9-2.2,2.5l-1.7,0
	l0-1.8c0-0.1,0-0.2,0-0.3c-0.1-0.5-0.5-0.8-1-0.8c-0.5,0-0.9,0.4-0.9,0.8c0,0.1,0,0.2,0,0.3l0,1.8l-0.2,0c-0.5,0-1,0-1.6,0
	C8,14.8,7.3,14,7,12.9c-0.1-0.3-0.2-0.5-0.5-0.6c-0.2-0.1-0.3-0.1-0.5-0.1c-0.1,0-0.2,0-0.3,0c-0.5,0.1-0.9,0.7-0.7,1.3
	c0.2,0.7,0.5,1.4,1,2c-0.2-0.1-0.5-0.2-0.8-0.3c-1.2-0.6-2-1.4-2.5-2.4C2.1,11.3,2.1,10.1,2.6,9C3.1,8,3.9,7.4,4.9,7.2
	c0.1,0.3,0.3,0.5,0.5,0.6c0.5,0.2,1,0,1.3-0.5C6.8,7.3,6.8,7.2,6.9,7C6.9,6.9,7,6.8,7,6.7c1.2-2,2.9-3,5.2-2.9c2.3,0.1,4,1.2,5,3.5
	c0,0.1,0.1,0.1,0.1,0.2c0.3,0.4,0.8,0.6,1.3,0.4c0.3-0.1,0.5-0.4,0.6-0.6c0,0,0,0,0.1,0c1.6,0.4,2.7,2,2.5,3.7v0
	c-0.2,2.2-1.7,3.9-3.8,4.5C18.3,14.8,18.7,14.2,18.9,13.4z"/>
	</symbol>



        <symbol xmlns="http://www.w3.org/2000/svg" viewBox="-12 1 24 24" id="icon-grid">
		<g>
		<path d="M-2.5,2.5h-7c-0.6,0-1,0.4-1,1v7c0,0.6,0.4,1,1,1h7c0.6,0,1-0.4,1-1v-7C-1.5,2.9-1.9,2.5-2.5,2.5z"/>
		<path d="M9.5,2.5h-7c-0.6,0-1,0.4-1,1v7c0,0.6,0.4,1,1,1h7c0.6,0,1-0.4,1-1v-7C10.5,2.9,10.1,2.5,9.5,2.5z"/>
		<path d="M-2.5,14.5h-7c-0.6,0-1,0.4-1,1v7c0,0.6,0.4,1,1,1h7c0.6,0,1-0.4,1-1v-7C-1.5,14.9-1.9,14.5-2.5,14.5z"/>
		<path d="M9.5,14.5h-7c-0.6,0-1,0.4-1,1v7c0,0.6,0.4,1,1,1h7c0.6,0,1-0.4,1-1v-7C10.5,14.9,10.1,14.5,9.5,14.5z"/>
		</g>
	</symbol>





    </svg>

</div>

{{--<div class="sticky-footer" id="cookie-notice">--}}
{{--    <span class="float-right pr-2">--}}
{{--	<a href="#" onclick="setCookie('cookie_notice', 1, 999999999); $('#cookie-notice').slideUp(); return false;"--}}
{{--       class="btn btn-outline-light ml-2">Am înțeles</a>--}}
{{--    </span>--}}
{{--    Prin continuarea navigării pe Website-ul nostru confirmați--}}
{{--    acceptarea utlizarii fișierelor de tip cookie și politica de--}}
{{--    procesare a datelor personale (GDPR).--}}
{{--    Click <a href="{{route('site.page', 'politica-de-confidentialitate')}}" target="_blank"--}}
{{--             class="border-bottom">aici</a> pentru mai multe informații.--}}
{{--</div>--}}


<script src="{{asset('assets/site/js/cookieconsent.js')}}"></script>
<script src="{{asset('assets/site/js/init.js')}}"></script>

<script src="{{asset('assets/site/js/bootstrap.min.js')}}"></script>
<script src="{{asset('assets/site/js/glightbox.min.js')}}"></script>
<script src="{{asset('assets/site/js/swiper-bundle.min.js')}}"></script>
<script src="{{asset('assets/site/js/jquery.syotimer.min.js')}}"></script>
<script src="{{asset('assets/site/js/custom.js')}}?v=111a2"></script>
@yield('scripts')

</body>
</html>
