<a id="comments"></a>


<div class="fs-24 fw-800 mb-2">Comentarii ({{$reviews->count()}}) </div>


@if ($reviews->count())


@guest
<div class="mb-4 rounded-md border border-gray-300 border-2 d-flex align-items-center justify-content-between py-2 ps-4 pe-3">
    <div>
	Doar utilizatorii întregistrați pot comenta.
	<a href="{{route('login')}}" class="text-orange fw-600 "> Log in </a>
	sau
	<a href="{{route('register')}}" class="text-orange fw-600">cont nou</a>
    </div>

    <span class="bg-gray-300 text-gray-600 rounded-pill px-3 py-2 d-inline-block pointer-events-none">Trimite</span>
</div>
@endguest


@else


@guest

<div class="mb-4 rounded-md border border-gray-300 border-2 d-flex align-items-center justify-content-between py-2 ps-4 pe-3">
    <div>
	Doar utilizatorii întregistrați pot comenta.
	<a href="{{route('login')}}" class="text-orange fw-600 "> Log in </a>
	sau
	<a href="{{route('register')}}" class="text-orange fw-600">cont nou</a>
    </div>

    <span class="bg-gray-300 text-gray-600 rounded-pill px-3 py-2 d-inline-block pointer-events-none">Trimite</span>
</div>


@endguest

    <div class="fs-15 fw-600 mb-3 mb-md-4">Nu există niciun  comentariu, fii primul care comentează.</div>
    @endif


    <div class="leave-comment @guest d-none @endguest" id="review-form">
	@auth

	<form enctype="multipart/form-data" action="{{route('site.article.review.store', $article)}}" method="POST" class="form-review">
	    @csrf

	    <input type="hidden" name="parent_id" value="0">


	    <div class="leave-comment-field d-flex align-items-center align-items-md-start">
		<div class="bg-white d-flex align-items-end border border-2 border-gray-300 ps-2 ps-md-4 py-2 pe-2 rounded-md flex-grow-1">
		    <div class="text-area flex-grow-1">
			<textarea class="form-control p-0 pe-3" rows="1"  name="body" required="" placeholder="Lasă un comentariu..."></textarea>
		    </div>

		    <div class="attach-photo flex-none">
			<input type="file" class="form-control cursor-pointer px-2 py-3" name="photo" placeholder="&nbsp;">
			<svg class="icon icon-md fill-gray-600 icon-camera"> <use xlink:href="#icon-camera"></use> </svg>
			<svg class="icon icon-md fill-black icon-check"> <use xlink:href="#icon-check"></use> </svg>
		    </div>
		</div>

		<button type="submit" class="send-btn btn btn-custom ms-2 ms-md-3 px-md-3 py-md-2">
		    <span class="fw-600 d-none d-md-inline-block">Trimite</span>

		    <svg class="icon icon-md fill-black d-md-none"> <use xlink:href="#icon-send"></use> </svg>
		</button>
	    </div>


	    {{--<div class="row mb-4">--}}
	    {{--<div class="col-md-6">--}}
	    {{--<div class="form-group">--}}

	    {{--<label class="has-float-label">--}}
	    {{--<input type="text" class="form-control" name="comment-name"--}} {{--required="" placeholder="&nbsp;">--}}
			{{--<span>Nume</span>--}}
		    {{--</label>--}}

		{{--</div>--}}
	    {{--</div>--}}

            {{--<div class="col-md-6">--}}
		{{--<div class="form-group">--}}
		    {{--<label class="has-float-label">--}}
			{{--<input type="email" class="form-control" name="comment-email"--}} {{-- required="" placeholder="&nbsp;">--}}
			{{--<span>Email</span>--}}
			{{--</label>--}}
			{{--</div>--}}
			{{--</div>--}}

    {{--</div>--}}

	<!--@include('site.parts.approve_gdpr')-->

	<!--<p class="small text-muted">  Numele va fi public la postare. </p>-->

	</form>

	@endauth

	@guest
	<div class="alert alert-warning">
	    Trebuie să fii autentificat pentru a publica un comentariu.
	</div>
	@endguest
    </div>


    <div class="comment-list mt-4">
	@foreach ($reviews as $review)

	<a id="comment-{{$review->id}}"></a>

	<div class="comment d-flex">

	    <div class="user-initial me-2 me-md-3">{{$review->user->getName()[0]}}</div>

	    <div class="bg-gray-200 rounded-lg p-3 p-md-4 pb-3 flex-grow-1">
		<div class="mb-3">
		    <div class="fw-700 d-flex align-items-center">
			{{$review->user ? $review->user->getName() : 'user sters'}}

			 @if ($review->user && $review->user->isAdmin())
			<svg class="icon icon-xs ms-1"> <use xlink:href="#icon-verified"></use> </svg>
			<!--<span class="badge bg-primary px-2 py-1 rounded-2 text-black"> Superchef </span>-->
			@endif
		    </div>

		    <div class="fs-15"> {{$review->created_at->diffForHumans()}}  </div>

		</div>

		<div class="comment__content fw-600">
		    {!!StringOperation::safeText($review->body)!!}
		</div>


		@if ($review->hasPhoto())
		    <div class="comment__picture mt-2">
			<a href="{{$review->getPhotoUrl()}}" class="glightbox" data-lightbox="comment-photo">
			    <img src="{{$review->getPhotoUrl()}}" alt=""  class="img-fluid">
			</a>
		    </div>
		@endif

		<div class="text-end">
		    <button type="button" class="btn show-comment-form p-0" data-parent-id="{{$review->id}}">
			<svg class="icon icon-sm"> <use xlink:href="#icon-message-circle"></use> </svg>
			<span class="fw-700">Răspunde</span>
		    </button>
		</div>

	    </div>

        </div>

            @foreach ($review->children as $review_child)
		<div class="comment mt-md-n3 mt-lg-n4 ps-3 ms-3 ms-md-5 d-flex">

		    <div class="user-initial me-3">{{$review_child->user->getName()[0]}}</div>

		    <div class="bg-gray-200 rounded-lg p-3 p-md-4 flex-grow-1">
			<div class="mb-3">
			    <div class="d-flex align-items-center">
				<span class="fw-700">
				    {{$review_child->user ? $review_child->user->getName() : 'user sters'}}
				</span>

				@if ($review_child->user && $review_child->user->isAdmin())
				<svg class="icon icon-xs ms-1"> <use xlink:href="#icon-verified"></use> </svg>
				<!--<span class="badge bg-primary px-2 py-1 rounded-2 text-black">Superchef </span>-->
				@endif
			    </div>

			    <div class="fs-15">{{$review_child->created_at->diffForHumans()}}</div>

			</div>

			<div class="comment__content fw-600"> {!!StringOperation::safeText($review_child->body)!!} </div>

			@if ($review_child->hasPhoto())
			    <div class="comment__picture mt-2">
				<a href="{{$review_child->getPhotoUrl()}}" class="glightbox" data-lightbox="comment-photo">
				    <img src="{{$review_child->getPhotoUrl()}}" alt="" class="img-fluid">
				</a>
			    </div>
			@endif
		    </div>
		</div>
	    @endforeach
        @endforeach
    </div>


	<script>
    $('.show-comment-form').click(function () {
        var $injected_form = $(this).siblings('form');
        if ($injected_form.length) {
            if (!$injected_form.find('textarea').val()) {
                $(this).siblings('form').remove();
            }
            return;
        }
        $('.comment-list form').hide();
        $form = $('#review-form').children().clone();
        $form.addClass('small my-3 border-left border-primary pl-3 ml-3 ml-md-5 leave-comment').find('input[name=parent_id]').val(this.dataset.parentId);
        $(this).after($form);
        fpro();
    })
</script>