@extends('layouts.site')
@section('title', __('Portfolio'))
@section('displayFooterNotice', 1)



@section('content')
<section class="subheader subheader--portofolio"></section>

<section class="portofoliu-gallery my-5">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center my-5 pb-5">
                <div class="title last-word">@lang('Projects made by Landisa')</div>
            </div>


            @if ($portfolio->description)
                <div class="container mb-5 px-5">
                    <div class="row">
                        <div class="col-md-12 text-justify">
                            <div>
                                {!!nl2br($portfolio->description)!!}
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            <div class="col-md-12">
                <div class="row no-gutters">

                    @foreach ($photos as $photo)
                    <div class="col-md-3">
                        <div class="grid popup-gallery">
                            <div class="overflow-hidden portofolio">
                                <a href="{{$photo->getPhotoUrl()}}" title="{{$photo->filename}}">
                                    <img class="img-fluid grid__img  anim" src="{{$photo->getThumbUrl()}}">
                                </a>
                            </div>
                        </div>
                    </div>
                    @endforeach

                </div>
            </div>
            <div class="col-md-12 text-center">
                <div class="pagination-bar p-3">
                    <nav>
                        {{$photos->links()}}

                    </nav>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection