<?php

/*
  |--------------------------------------------------------------------------
  | Web Routes
  |--------------------------------------------------------------------------
  |
  | Here is where you can register web routes for your application. These
  | routes are loaded by the RouteServiceProvider within a group which
  | contains the "web" middleware group. Now create something great!
  |
 */


// admin group
Route::group(['prefix' => 'admin', 'namespace' => 'Admin', 'middleware' => 'admin', 'as' => 'admin.'], function () {
    Route::get('/', 'IndexController@index');
    Route::resource('categories', 'CategoryController');
    Route::post('categories/priority', 'CategoryController@priority')->name('categories.priority');


    Route::resource('reviews', 'ReviewController');
//    Route::resource('brands', 'BrandController');
//    Route::any('brands/photo/{brand}', 'BrandController@photo')->name('brands.photo');

//    Route::resource('videos', 'VideoController');


//    Route::resource('ads', 'AdController');
//    Route::post('ads/priority', 'AdController@priority')->name('ads.priority');


//    Route::resource('covers', 'CoverController');

    Route::resource('articles', 'ArticleController');
    Route::any('articles/photo/{article?}', 'ArticleController@photo')->name('articles.photo');
    Route::any('articles/photos/{article?}', 'ArticleController@photos')->name('articles.photos');

    Route::any('articles/{article}/ingredients/add/{step_category_index}', 'ArticleController@ingredientAdd')->name('articles.ingredients.add');
    Route::any('articles/{article}/ingredients/delete/{step_category_index}/{step_index}', 'ArticleController@ingredientDelete')->name('articles.ingredients.delete');
    Route::any('articles/{article}/ingredients/category', 'ArticleController@ingredientNewCategory')->name('articles.ingredients.category');

    Route::any('articles/{article}/steps/add/{step_category_index}', 'ArticleController@stepAdd')->name('articles.steps.add');
    Route::any('articles/{article}/steps/delete/{step_category_index}/{step_index}', 'ArticleController@stepDelete')->name('articles.steps.delete');
    Route::any('articles/{article}/steps/category', 'ArticleController@stepNewCategory')->name('articles.steps.category');
    Route::any('articles/{article}/steps/photo/{step_category_index}/{step_index}', 'ArticleController@stepPhoto')->name('articles.steps.photo');

    Route::resource('articles.documents', 'ArticleDocumentController');

//    Route::get('articles/search', 'ProductController@search')->name('articles.search');
//    Route::post('articles/priority', 'ProductController@priority')->name('products.priority');

//    Route::resource('texts', 'TextController');

//    Route::resource('galleries', 'GalleryController');
//    Route::any('galleries/photo/{gallery}', 'GalleryController@photo')->name('galleries.photo');


//    Route::get('newsletters', 'NewsletterController@index')->name('newsletters.index');


    Route::get('import', 'ImportController@index')->name('import');


    Route::resource('users', 'UserController');
});


// client group
Route::group(['prefix' => 'client', 'namespace' => 'Client', 'middleware' => ['logged'], 'as' => 'client.'], function () {
    Route::get('/', 'IndexController@index');
});

Auth::routes();
Route::get('logout', 'Auth\LoginController@logout')->name('logout');
//Route::get('login/facebook', 'Auth\LoginFacebookController@redirectToProvider')->name('login.facebook');
//Route::get('login/facebook/callback', 'Auth\LoginFacebookController@handleProviderCallback')->name('login.facebook.callback');
//Route::get('login/google', 'Auth\LoginGoogleController@redirectToProvider')->name('login.google');
//Route::get('login/google/callback', 'Auth\LoginGoogleController@handleProviderCallback')->name('login.google.callback');

Route::group(['namespace' => 'Site', 'as' => 'site.'], function () {

    Route::get('/', 'IndexController@index');
    Route::get('sitemap.txt', 'SitemapController@index')->name('sitemap');
    Route::get('sitemap2.txt', 'SitemapController@index')->name('sitemap');

//    Route::get('blog/{category?}', 'ArticleController@index')->name('articles.index');
    Route::get('blog', 'ArticleController@index')->name('articles.index');
    Route::get('blog/{slug}-{article}', 'ArticleController@showBlogArticle')
        ->where('slug', '[0-9a-z\-]+')
        ->where('article', '[0-9]+')
        ->name('articles.show');
    Route::get('article/{article}', 'ArticleController@showById')->name('articles.showById');


//    Route::get('retete-culinare/{category:slug?}', 'ArticleController@index')->name('recipes.index');

      Route::get('retete/{category:slug?}', 'ArticleController@index')->name('recipes.index');



    Route::get('reteta/{slug}-{article}/{two?}', 'ArticleController@show')
        ->where('slug', '[0-9a-z\-]+')
        ->where('article', '[0-9]+')
        ->name('recipes.show');

//     Route::get('reteta/{slug}-{article}/two', 'ArticleController@showTwo')
//        ->where('slug', '[0-9a-z\-]+')
//        ->where('article', '[0-9]+')
//        ->name('recipes.show-two-colums');



    Route::get('tag/{tag:slug}', 'ArticleController@indexByTag')->name('articles.tag');

    Route::post('article/{article}', 'ArticleController@storeReview')->name('article.review.store');


//    Route::any('voucher/check', 'VoucherController@check')->name('voucher.check');

//    Route::get('visit-link/{ad}', 'AdController@redirect')->name('ads.redirect');


//    Route::get('media', 'GalleryController@index')->name('galleries');
//    Route::get('media/{slug}/{gallery}', 'GalleryController@show')->name('gallery');


//    Route::post('newsletter', 'NewsletterController@subscribe')->name('newsletter');


//    Route::any('contact', 'ContactController@contact')->name('contact');
//    Route::post('contact/process', 'ContactController@contact')->name('contact.process');
//
//    Route::get('{article:slug?}', 'ArticleController@showPage')
////        ->where(['page' => '[a-z0-9_-]+'])
//        ->name('page');


    // static pages
    Route::get('page/{page}', 'PageController@index')->where(['page' => '[a-z0-9_-]+'])->name('page');



//    // blackhole
//    Route::fallback(function () {
//        return redirect(route('site.recipes.index'), 301);
//    })->name('fallback');

});


//if (request('test')) {
//    \Event::listen('Illuminate\Database\Events\QueryExecuted', function ($query) {
//        ;
//        echo '<pre>';
//        var_dump($query->sql);
//        var_dump($query->bindings);
//        var_dump($query->time);
//        echo '</pre>';
//    });
//}


// var_export(\Illuminate\Support\Facades\DB::getQueryLog());