<?php $__env->startSection('title', 'Login'); ?>


<?php $__env->startSection('content'); ?>

<section class="login-register-section ">
    <img src="<?php echo e(asset('assets/site/images/login-register-bg.webp')); ?>" srcset="<?php echo e(asset('assets/site/images/login-register-bg.webp')); ?> 1000w, <?php echo e(asset('assets/site/images/login-register-bg.webp')); ?> 1500w" class="img-fluid section__img" alt="">
    <div class="container">
	<div class="row justify-content-center">
	    <div class="col-md-9 col-lg-7 col-xl-5 col-xxl-6">
		<div class="login-register-form px-4 px-md-5 py-5 mx-md-4">
		    <div class="px-md-2">
			<div class="text-center mb-4 mb-xl-5">
			    <div class="fw-700 fw-md-800 fs-36 mb-2">Log in</div>
			    <div class="fw-600 fs-24">Bine ai revenit pe Superchef</div>
			</div>

			<div>
			    <a href="#" class="btn btn-block btn-outline-black rounded-pill d-flex align-items-center justify-content-center border border-black border-2 mb-3 py-2">
				<svg class="icon icon-sm fill-facebook-blue me-2"> <use xlink:href="#icon-facebook-circle"></use> </svg>
				<span class="fw-700">Log in cu Facebook</span>
			    </a>

			    <a href="#" class="btn btn-block btn-outline-black rounded-pill d-flex align-items-center justify-content-center border border-black border-2 py-2">
				<svg class="icon icon-sm me-2"> <use xlink:href="#icon-google"></use> </svg>
				<span class="fw-700">Log in cu Google</span>
			    </a>
			</div>

			<div class="my-5 d-flex align-items-center justify-content-center">
			    <span class="border flex-grow-1"></span>
			    <span class="mx-4">sau log in cu email</span>
			    <span class="border flex-grow-1"></span>
			</div>

			<div>
			    <?php echo $__env->make('auth.3rdparty', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
			    <form class="form-horizontal pt-30" method="POST" action="<?php echo e(route('login')); ?>">
				<?php echo e(csrf_field()); ?>


				<div class="form-group<?php echo e($errors->has('email') ? ' has-error' : ''); ?> mb-3">

				    <label class="has-float-label">
					<input id="email" type="email" class="form-control" name="email" value="<?php echo e(old('email')); ?>" required placeholder="&nbsp;">
					<span>Email</span>
				    </label>

				    <?php if($errors->has('email')): ?>
				    <span class="help-block">
					<strong><?php echo e($errors->first('email')); ?></strong>
				    </span>
				    <?php endif; ?>
				</div>

				<div class="form-group<?php echo e($errors->has('password') ? ' has-error' : ''); ?>">

				    <div class="password-field">
					<label class="has-float-label mb-2 input-holder-pass">
					    <input id="password" type="password" class="form-control" name="password" required placeholder="&nbsp;">
					    <span><?php echo e(__('Password')); ?></span>

					    <div class="see-password me-3">
						<input type="checkbox" class="toggle-visibility cursor-pointer">
						<div class="icon-holder">
						    <svg class="icon icon-sm fill-gray-600"> <use xlink:href="#icon-eye"></use></svg>
						</div>
					    </div>
					</label>
				    </div>

				    <?php if($errors->has('password')): ?>
					<span class="help-block">
					    <strong><?php echo e($errors->first('password')); ?></strong>
					</span>
				    <?php endif; ?>

				</div>

				<div class="d-flex align-items-center justify-content-between mb-4">

				    <div class="form-check">
					<input type="checkbox" name="remember" class="form-check-input"  id="remember" <?php echo e(old('remember') ? 'checked' : 'checked'); ?>>

					       <label class="form-check-label fw-600 ms-1" for="remember"><?php echo e(__('Remember Me')); ?></label>
				    </div>


				    <a class="btn text-orange fw-600  mt-2" href="<?php echo e(route('password.request')); ?>">
					<?php echo e(__('Forgot Your Password?')); ?>

				    </a>
				</div>

				<button type="submit" class="btn btn-custom w-100 mt-2 mb-4 mb-xl-5">
				    <?php echo e(__('Login')); ?>

				</button>

				<div class="text-center fw-600">
				    Nu ai cont?
				    <a class="text-orange mt-2" href="<?php echo e(route('register')); ?>">
					Deschide un cont nou.
                                    </a>
				</div>
			    </form>
			</div>
		    </div>
		</div>
	    </div>
	</div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/superch1/public_html/resources/views/auth/login.blade.php ENDPATH**/ ?>