<?php $__env->startSection('title', $review->exists ? "Editare {$review->name}" : 'Creare review nou'); ?>

<?php $__env->startSection('content'); ?>

    <div class="tabs-container">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#tab-1" aria-expanded="true">De baza</a></li>

        </ul>
        <div class="tab-content">
            <div id="tab-1" class="tab-pane active">
                <div class="panel-body">
                    <form action="<?php echo e(route('admin.reviews.update', $review)); ?>" method="POST" class="form-horizontal">

                        <?php echo e(method_field($review->exists ? 'PUT' : 'POST' )); ?>

                        <?php echo e(csrf_field()); ?>


                        <?php if($review->user): ?>
                            <p>
                                
                                Autor:
                                <a href="<?php echo e(route('admin.users.edit', $review->user)); ?>">
                                    <?php echo e($review->user->getName()); ?>

                                </a>
                            </p>
                        <?php else: ?>
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Nume</label>
                                <div class="col-sm-10">
                                    <input type="text" name="name" value="<?php echo e((old('name')) ?: $review->name); ?>"
                                           class="form-control" autofocus="autofocus" required/>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-2 control-label">Email</label>
                                <div class="col-sm-10">
                                    <input type="text" name="email" value="<?php echo e((old('email')) ?: $review->email); ?>"
                                           class="form-control" autofocus="autofocus" required/>
                                </div>
                            </div>
                        <?php endif; ?>


                        <div class="form-group">
                            <label class="col-sm-2 control-label">Mesaj</label>
                            <div class="col-sm-10">
                                <textarea required class="form-control" rows="8"
                                          name="body"> <?php echo e((old('body')) ?: $review->body); ?></textarea>
                            </div>
                        </div>

                        <?php if($review->hasPhoto()): ?>
                            <p>
                                Poza:
                            </p>
                            <img src="<?php echo e($review->getPhotoUrl()); ?>" style="max-width: 200px" />
                        <?php endif; ?>

                        <div class="hr-line-dashed"></div>
                        <div class="form-group">
                            <div class="col-sm-4 col-sm-offset-2">
                                <button class="btn btn-primary" type="submit">Salveaza</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>


    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/superch1/public_html/resources/views/admin/review/edit.blade.php ENDPATH**/ ?>