<?php /** @var \App\Model\Article $article */ ?>
<?php /** @var \App\Model\Article\ArticlePhoto $photo */ ?>


<?php $__env->startSection('title', $article->title); ?>
<?php $__env->startSection('url', url()->current()); ?>


<?php $__env->startSection('meta'); ?>
<meta property="og:locale" content="ro_RO"/>
<meta property="og:locale:alternate" content="ro_RO"/>
<meta property="og:site_name" content="<?php echo e(config('app.name')); ?>"/>
<meta property="og:title" content="<?php echo e($article->title); ?>"/>
<meta property="og:url" content="<?php echo $__env->yieldContent('url'); ?>"/>
<meta property="og:type" content="Article"/>
<?php if($article->photos->count()): ?>
<meta property="og:image" content="<?php echo e($article->photos->first()->getThumbUrl()); ?>"/>
<?php endif; ?>

<script type="application/ld+json">
    {
    "@context": "https://schema.org/",
    "@type": "Recipe",
    "name": "<?php echo e($article->title); ?>",
    "image": [
    "<?php echo e($article->getThumbUrl()); ?>"
    ],
    "author": {
    "@type": "Person",
    "name": "<?php echo e(config('app.name')); ?>"
    },
    "datePublished": "<?php echo e($article->published_at ? $article->published_at->format('Y-m-d') : $article->created_at->format('Y-m-d')); ?>",
    "description": "<?php echo e(Str::words(StringOperation::extractText($article->body), 30)); ?>",
    "prepTime": "PT<?php echo e($article->params->time_preparing ?? 0); ?>M",
    "cookTime": "PT<?php echo e($article->params->time_cooking ?? 0); ?>M",
    "totalTime": "PT<?php echo e($article->params->time_ready ?? 0); ?>M",
    "keywords": "<?php echo e($article->tags->pluck('name')->implode(', ')); ?>",
    "recipeYield": "<?php echo e($article->params->servings ?? $article->params->yield ?? ''); ?>",
    "recipeCategory": "<?php echo e($article->params->course ?? ''); ?>",
    "recipeCuisine": "<?php echo e($article->params->cuisine ?? ''); ?>"
    }


</script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function () {
	var paragraphs = $(".recipe__body > p, .recipe__body img");
	var first = paragraphs.first();
	var totalParagraphs = paragraphs.length;

	// insert ad in first paragraph
	// need our pub-ID here (andrei)

	if (first.length) {
	    first.after('<div class="my-3" style="width: 100%"><ins class=adsbygoogle style=display:block data-ad-client=ca-pub-0000000000 data-ad-slot=0000000000  data-ad-format=auto data-full-width-responsive=true></ins></div>');
	    (adsbygoogle = window.adsbygoogle || []).push({});
	}

	if (totalParagraphs >= 10) {
	    // insert ad after paragraph no 25%
	    paragraphs.eq(Math.ceil(totalParagraphs * 20 / 100) - 1)
		    .after('<div class="my-3" style="width: 350px; height: 350px;"><ins class=adsbygoogle style="display:block; text-align:center;" data-ad-layout=in-article data-ad-format=fluid data-ad-client=ca-pub-0000000000  data-ad-slot=0000000000 ></ins></div>');
	    (adsbygoogle = window.adsbygoogle || []).push({});

	    // insert ad after paragraph no 50% and 75%
	    var selectedParagraphs = [
		paragraphs.eq(Math.ceil(totalParagraphs * 50 / 100) - 1),
		paragraphs.eq(Math.ceil(totalParagraphs * 75 / 100) - 1),
	    ];
	    selectedParagraphs.forEach(function (paragraph) {
		paragraph.after('<div class="my-3" style="width: 100%"><ins class=adsbygoogle style="display:block; text-align:center;" data-ad-layout=in-article data-ad-format=fluid data-ad-client=ca-pub-0000000000  data-ad-slot=0000000000 ></ins></div>');
		(adsbygoogle = window.adsbygoogle || []).push({});
	    });

	}
    });

</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<section class="py-5">
    <div class="container container--narow">
	<div class="row justify-content-center recipe__details">
	    <div class="col-md-12">
		<div class="d-flex align-items-center mb-4 pb-4">
		     <!-- <?php echo e(route('site.recipes.index')); ?>-->
		     
		    <a href="<?php echo e($article->category->getUrl()); ?>" class="me-3"> 
			<svg class="icon icon-md fill-black stroke-1 stroke-black circle-icon bg-gray-300"> <use xlink:href="#icon-arrow-left"></use> </svg>
		    </a>

		    <nav aria-label="breadcrumb" class="breadcrumb-holder">
			<ol class="breadcrumb mb-0 pe-3 pb-0">
			    <li class="breadcrumb-item ">
				<a href="<?php echo e(route('site.')); ?>" class="line-height-20">
				    <svg class="icon icon-sm fill-black "> <use xlink:href="#icon-home"></use> </svg>
				</a>
			    </li>
			    <li class="breadcrumb-item"><a href="<?php echo e(route('site.recipes.index')); ?>">Rețete</a></li>
			    <li class="breadcrumb-item"><a href="<?php echo e($article->category->getUrl()); ?>"><?php echo e($article->category->name); ?></a></li>
			    <li class="breadcrumb-item active" aria-current="page"><?php echo e($article->title); ?></li>
			</ol>
		    </nav>
		</div>

		<h1 class="fs-40 fw-800"> <?php echo e($article->title); ?> </h1>

		<div class="d-flex flex-wrap mb-3 mb-md-4 mb-lg-5">
		    <div class="recipe__badge d-flex align-items-center">
			<svg class="icon icon-md fill-black me-2"> <use xlink:href="#icon-award"></use> </svg>
			<?php echo e($article->params->skill ?? '-'); ?>

		    </div>
		    <div class="recipe__badge d-flex align-items-center">
			<svg class="icon icon-md fill-black me-2"> <use xlink:href="#icon-clock"></use> </svg>
			<?php echo e($article->params->time_preparing ?? 0); ?> minute
		    </div>
		</div>

		<div class="recipe__cover mb-4 mb-md-5">
		    <img src="<?php echo e($article->photos->first()->getThumbUrl()); ?>" alt="" class="img-fluid">
		</div>

		<div class="recipe-menu-holder mb-4 mb-md-5 ">
		    <div class="recipe-menu pe-3 py-3 p-md-3 d-flex justify-content-between">
			<a class="btn" href="#detalii">Detalii</a>

			<a class="btn" href="#lista-ingrediente">Ingrediente</a>

			<a class="btn" href="#mod-preparare">Mod de preparare</a>

			<a class="btn" href="#comentarii">Comentarii (<?php echo e($reviews->count()); ?>)</a>

		    </div>
		</div>


		<div class="recipe-menu__items">

		    <div class="mb-4 md-mb-5 menu-item" id="detalii">
			<div class="fs-24 fw-800 mb-3">Detalii</div>
			<?php echo $article->body; ?>

		    </div>

		    <div class="mb-4 md-mb-5 menu-item" id="lista-ingrediente">
			<div class="fs-24 fw-800 mb-3">Lista cu ingrediente</div>

			<?php $__currentLoopData = $article->ingredients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ingredient_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

			<div class="fw-600 fs-18 text-orange mb-1">
			    <?php echo e($ingredient_group->name); ?>

			</div>

			<div class="ingredient-list mb-4 mb-lg-5">
			    <?php if(isset($ingredient_group->items)): ?>
			    <ul class="list-unstyled mb-0 border-top">
				<?php $__currentLoopData = collect($ingredient_group->items)->map(fn($item) => explode("\n", $item))->flatten(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<?php if(!$item) continue; ?>
				<li class="border-bottom border-gray-300 py-3">
				    <div class="form-check d-flex align-items-center justify-content-between ps-0">

					<input class="form-check-input order-last cursor-pointer" type="checkbox" value="" id="<?php echo e(str_replace(' ','-',$item)); ?>">

					<label class="form-check-label order-first cursor-pointer" for="<?php echo e(str_replace(' ', '-', $item)); ?>">
					    <?php echo e($item); ?>

					</label>


				    </div>
				</li>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			    </ul>
			    <?php endif; ?>

			</div>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		    </div>

		    <div class="mb-4 md-mb-5 menu-item" id="mod-preparare">
			<div class="fs-24 fw-800 mb-3">Mod de preparare</div>

			<?php if(!empty($article->steps)): ?>
                        <?php $__currentLoopData = $article->steps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $step_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<div class="preparation-steps mb-4">

			    <?php $__currentLoopData = $step_group->steps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			    <div class="step border border-2 border-gray-300 mb-3">

				<div class="step__nr fw-800 mb-3 text-gray-600"><?php echo e($loop->iteration); ?> / <?php echo e($loop->count); ?></div>

				<div class="step__description fs-18">
				    <?php echo nl2br($step->text); ?>

				</div>
			    </div>
			    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

			</div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			<?php endif; ?>

			<div class="text-center see-more-steps" style="display: none">
			    <button class="btn rounded-pill border border-2 show-all-steps px-4 py-2">
				<span class="text-black fw-700"> Vezi mai mult</span>

				<svg class="icon icon-xs  stroke-1 stroke-black fill-black ms-1"> <use xlink:href="#icon-chevron-down"></use> </svg>
			    </button>
			</div>

		    </div>

		    <div class="mb-4 md-mb-5 menu-item mt-4 mt-md-5" id="comentarii">
			<?php echo $__env->make('site.article.comments', ['reviews' => $reviews], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		    </div>
		</div>

	    </div>
	</div>
    </div>
</section>
<?php if($articles->count()): ?>
<section class="pt-0">
    <div class="container container--narow">

	<div class="row justify-content-center">
	    <div class="col-md-12">

		<div class="mb-4 pb-4 border-bottom">
		    <?php if($article->tags->count()): ?>
		    <div class="fs-24 fw-800 mb-3">Taguri rețetă</div>

		    <div class="recipe--tags ms-n2">
			<?php $__currentLoopData = $article->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<a class="btn" href="<?php echo e($tag->getUrl()); ?>"> <?php echo e($tag->name); ?></a>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		    </div>
                    <?php endif; ?>
		</div>

		<div class="fs-24 fw-800 mb-3 ">Rețete asemănătoare</div>

		<div class="row row-cols-2 row-cols-sm-3 row-cols-lg-4 gx-2 gy-3 g-md-3 g-xl-4 mb-4 mb-xl-5">
		    <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		    <div class="col category-holder">

			<div class="recipe--grid">
			    <a href="<?php echo e($article->getRecipeUrl()); ?>" class="a-absolute"></a>
			    <div class="recipe__badge"><?php echo e($article->params->skill ?? '-'); ?></div>
			    <div class="recipe__img mb-2 mb-md-3 ratio ratio-4x5">
				<img src="<?php echo e($article->getThumbUrl()); ?>" alt="<?php echo e($article->title); ?>" class="img-fluid" loading="lazy">
			    </div>

			    <div class="recipe__category">
				<?php echo e($recipe->category->name ?? ''); ?>

			    </div>

			    <a href="<?php echo e($article->getRecipeUrl()); ?>" class="recipe__name">
				<?php echo e($article->title); ?>

			    </a>
			</div>
		    </div>
		    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

		</div>


	    </div>
	</div>
    </div>
</section>

<?php endif; ?>



<!--<?php echo $__env->make('site.parts.recipe_carousel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/superch1/public_html/resources/views/site/recipe/show.blade.php ENDPATH**/ ?>