

<?php $__env->startSection('title'); ?>
    Modificari baza <?php echo e($user->getName()); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="tabs-container">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#tab-1" aria-expanded="true">De baza</a></li>
            <?php if($user->exists): ?>
                                <li class=""><a data-toggle="tab" href="#tab-2" aria-expanded="false">Contacte atasate</a></li>



            <?php endif; ?>
        </ul>
        <div class="tab-content">
            <div id="tab-1" class="tab-pane active">
                <div class="panel-body">
                    <form action="<?php echo e(route('admin.users.update', $user)); ?>" method="POST" class="form-horizontal">
                        <input type="hidden" name="_redirect" value="<?php echo e(url()->previous()); ?>" class="form-control">
                        <?php echo e(method_field($user->exists ? 'PUT' : 'POST' )); ?>

                        <?php echo e(csrf_field()); ?>

                        <hr/>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Email</label>
                            <div class="col-sm-10">
                                <input type="email" name="email" value="<?php echo e((old('email')) ?: $user->email); ?>"
                                       class="form-control">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Parola noua</label>
                            <div class="col-sm-10">
                                <input type="password" name="new_password" value="" class="form-control">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label"></label>
                            <div class="col-sm-10">
                                <label class="checkbox-inline">
                                    <input type="hidden" name="is_admin" value="0"/>
                                    <input type="checkbox" name="is_admin" value="1" class="i-checks"
                                           <?php if($user->isAdmin()): ?>
                                           checked="checked"
                                            <?php endif; ?>
                                    /> Administrator
                                </label>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Nume</label>
                            <div class="col-sm-10">
                                <input type="text" name="name" value="<?php echo e((old('name')) ?: $user->name); ?>"
                                       class="form-control">
                            </div>
                        </div>
                        <div class="hr-line-dashed"></div>
                        <div class="form-group">
                            <div class="col-sm-4 col-sm-offset-2">
                                <button class="btn btn-primary" type="submit">
                                    Salveaza
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div id="tab-2" class="tab-pane">
                <?php if($user->exists): ?>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="ibox">
                                    <div class="ibox-title">
                                        <h1>
                                            Cont
                                        </h1>
                                    </div>
                                    <div class="ibox-content">

                                        <p class="mb-1">
                                            <span class="text-muted">Inregistrat:</span> <?php echo e($user->created_at); ?>

                                        </p>
                                        <p class="mb-1">
                                            <span class="text-muted">Email:</span> <?php echo e($user->email); ?>

                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <?php if(!empty($user->deliveryContact)): ?>
                                <div class="col-lg-6">
                                    <div class="ibox">
                                        <div class="ibox-title">
                                            <h1>
                                                Adresa livrare
                                            </h1>
                                        </div>
                                        <div class="ibox-content">

                                            <p class="mb-1">
                                                <span class="text-muted">Nume si Prenume:</span> <?php echo e($user->deliveryContact->getName()); ?>

                                            </p>
                                            <p class="mb-1">
                                                <span class="text-muted">Adresa:</span> <?php echo e($user->deliveryContact->address); ?>

                                                , <?php echo e($user->deliveryContact->postalcode); ?>

                                                , <?php echo e($user->deliveryContact->city); ?>

                                                , <?php echo e($user->deliveryContact->county->name); ?>.
                                            </p>
                                            <p class="mb-1">
                                                <span class="text-muted">Telefon:</span> <?php echo e($user->deliveryContact->phone); ?>

                                            </p>
                                            <p class="mb-1">
                                                <span class="text-muted">Email:</span> <?php echo e($user->deliveryContact->email ?? $user->email); ?>

                                            </p>
                                        </div>
                                    </div>
                                </div>



                                <?php if(!empty($user->billingContact)): ?>
                                    <div class="col-lg-6">
                                        <div class="ibox">
                                            <div class="ibox-title">
                                                <h1>
                                                    Adresa facturare
                                                </h1>
                                            </div>
                                            <div class="ibox-content">

                                                <?php if($user->billingContact->type == 'company'): ?>
                                                    <p class="mb-1">
                                                        <span class="text-muted">Nume firmă:</span> <?php echo e($user->billingContact->company_name); ?>

                                                    </p>
                                                    <p class="mb-1">
                                                        <span class="text-muted">CUI:</span> <?php echo e($user->billingContact->company_cui); ?>

                                                    </p>
                                                    <p class="mb-1">
                                                        <span class="text-muted">Nr reg. com.:</span> <?php echo e($user->billingContact->company_reg); ?>

                                                    </p>
                                                    <p class="mb-1">
                                                        <span class="text-muted">Cont bancar:</span> <?php echo e($user->billingContact->bankaccount); ?>

                                                    </p>
                                                <?php endif; ?>

                                                
                                                
                                                
                                                <p class="mb-1">
                                                    <span class="text-muted">Adresa:</span> <?php echo e($user->billingContact->address); ?>

                                                    , <?php echo e($user->billingContact->postalcode); ?>

                                                    , <?php echo e($user->deliveryContact->city); ?>

                                                    , <?php echo e($user->deliveryContact->county->name); ?>.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <script>
        $('.i-checks').iCheck({
            checkboxClass: 'icheckbox_square-green',
            radioClass: 'iradio_square-green',
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/superch1/public_html/resources/views/admin/user/edit.blade.php ENDPATH**/ ?>