<?php $__env->startSection('title', 'Comentarii'); ?>


<?php $__env->startSection('content'); ?>
    <div class="ibox">
        <div class="ibox-content table-responsive">
            <table class="table table-striped-or-not table-hover">
                <thead>
                <tr>
                    <th>Autor</th>
                    <th>Mesaj</th>
		
		<th>Articol</th>
                    <th class="text-right">Actiuni</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr role="button">
                        <td>
                            <?php if($review->user): ?>
                                <a href="<?php echo e(route('admin.users.edit', $review->user)); ?>">
                                    <?php echo e($review->user->getName()); ?>

                                </a>
                            <?php else: ?>
                                <?php echo e($review->name); ?> (<?php echo e($review->email); ?>)
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php echo StringOperation::safeText($review->body); ?>

                            <?php if($review->hasPhoto()): ?>
                                <div>
                                    <a target="_blank" href="<?php echo e($review->getPhotoUrl()); ?>">
                                        <img src="<?php echo e($review->getPhotoUrl()); ?>" class="img-thumbnail m-t-xs" style="max-height: 80px;"/>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <form action="<?php echo e(route('admin.reviews.update', $review)); ?>" method="POST" class="m-t-xs">
                                <?php echo e(method_field('PUT')); ?>

                                <?php echo e(csrf_field()); ?>

                                <input type="hidden" name="is_active" value="<?php echo e((int)!$review->is_active); ?>"/>
                                <input type="submit" value="<?php echo e($review->is_active ? 'dezaproba' : 'aproba'); ?>"
                                       class="btn btn-xs <?php echo e(!$review->is_active ? 'btn-primary' : 'btn-warning'); ?>"/>


                            </form>

                        </td>
                        
                        
			    
                        <td>
                            <?php if($review->article): ?>
                                <a href="<?php echo e($review->article->getUrl()); ?>#comment-<?php echo e($review->id); ?>">
                                    <?php echo e($review->article->title); ?>

                                </a>
                            <?php else: ?>
                                articol sters
                            <?php endif; ?>
                        </td>
                        <td class="text-right">
                            <div class="modal" id="item-<?php echo e($review->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                <div class="modal-dialog text-left" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                            <h4 class="modal-title">Stergere obiect</h4>
                                        </div>
                                        <div class="modal-body text-left">
                                            <p>
                                                Sigur doriti sa stergeti acest review?
                                            </p>
                                        </div>
                                        <div class="modal-footer">
                                            <form action="<?php echo e(route('admin.reviews.destroy', $review)); ?>" method="POST">
                                                <?php echo e(method_field('DELETE')); ?>

                                                <?php echo e(csrf_field()); ?>

                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                                                    Anuleaza
                                                </button>
                                                <input type="submit" value="sterge" class="btn btn-danger"/>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <form action="<?php echo e(route('admin.reviews.update', $review)); ?>" method="POST">
                                <?php echo e(method_field('PUT')); ?>

                                <?php echo e(csrf_field()); ?>

                                <input type="hidden" name="is_active" value="<?php echo e((int)!$review->is_active); ?>"/>
                                <input type="submit" value="<?php echo e($review->is_active ? 'dezaproba' : 'aproba'); ?>"
                                       class="btn btn-xs <?php echo e(!$review->is_active ? 'btn-primary' : 'btn-warning'); ?>"/>

                                <a href="<?php echo e(route('admin.reviews.edit', $review)); ?>"
                                   class="btn btn-edit btn-xs btn-success">edit</a>
                                <a href="#" class="btn btn-xs btn-danger" data-toggle="modal"
                                   data-target="#item-<?php echo e($review->id); ?>">sterge</a>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div>
                <?php echo e($reviews->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/superch1/public_html/resources/views/admin/review/index.blade.php ENDPATH**/ ?>