<!--
*
*  INSPINIA - Responsive Admin Theme
*  version 2.7
*
-->

<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Admin'); ?></title>

    
    
    


    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">


    <link href="<?php echo e(asset('assets/admin/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/admin/font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">

    <!-- Toastr style -->
    <link href="<?php echo e(asset('assets/admin/css/plugins/toastr/toastr.min.css')); ?>" rel="stylesheet">

    <!-- Gritter -->
    <link href="<?php echo e(asset('assets/admin/js/plugins/gritter/jquery.gritter.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset('assets/admin/css/animate.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/admin/css/style.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset('assets/admin/css/plugins/iCheck/custom.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/admin/css/plugins/awesome-bootstrap-checkbox/awesome-bootstrap-checkbox.css')); ?>"
          rel="stylesheet">

    <link href="<?php echo e(asset('assets/admin/css/plugins/chosen/bootstrap-chosen.css')); ?>" rel="stylesheet">


    <!-- FooTable -->
    <link href="<?php echo e(asset('assets/admin/css/plugins/footable/footable.core.css')); ?>" rel="stylesheet">


    <!-- Mainly scripts -->
    <script src="<?php echo e(asset('assets/admin/js/jquery-3.1.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/plugins/metisMenu/jquery.metisMenu.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/plugins/slimscroll/jquery.slimscroll.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/common/js/common.js')); ?>?v=2111"></script>
    <script src="<?php echo e(asset('assets/common/js/PhotoUpload.js')); ?>"></script>


    <!-- Flot -->
    <script src="<?php echo e(asset('assets/admin/js/plugins/flot/jquery.flot.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/plugins/flot/jquery.flot.tooltip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/plugins/flot/jquery.flot.spline.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/plugins/flot/jquery.flot.resize.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/plugins/flot/jquery.flot.pie.js')); ?>"></script>

    <!-- Peity -->
    <script src="<?php echo e(asset('assets/admin/js/plugins/peity/jquery.peity.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/demo/peity-demo.js')); ?>"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo e(asset('assets/admin/js/inspinia.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/plugins/pace/pace.min.js')); ?>"></script>

    <!-- jQuery UI -->
    <script src="<?php echo e(asset('assets/admin/js/plugins/jquery-ui/jquery-ui.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/admin/js/plugins/iCheck/icheck.min.js')); ?>"></script>

    <!-- Typehead -->
    <script src="<?php echo e(asset('assets/admin/js/plugins/typehead/bootstrap3-typeahead.min.js')); ?>"></script>

    
    
    
    <script src="<?php echo e(asset('assets/admin/plugins/select2/js/select2.full.min.js')); ?>"></script>
    <link href="<?php echo e(asset('assets/admin/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">


    <link href="<?php echo e(asset('assets/admin/css/plugins/select2/select2-bootstrap.min.css')); ?>" rel="stylesheet">

    <script src="<?php echo e(asset('assets/admin/js/plugins/chosen/chosen.jquery.js')); ?>"></script>
    <!-- summer note reqs -->
    <link href="<?php echo e(asset('assets/admin/css/plugins/jQueryUI/jquery-ui.css')); ?>" rel="stylesheet">
    
    

    <link href="<?php echo e(asset('assets/admin/plugins/froala/css/froala_editor.pkgd.min.css')); ?>" rel="stylesheet"
          type="text/css"/>
    <link href="<?php echo e(asset('assets/admin/plugins/froala/css/froala_style.min.css')); ?>" rel="stylesheet" type="text/css"/>

    <script type="text/javascript"
            src="<?php echo e(asset('assets/admin/plugins/froala/js/froala_editor.pkgd.min.js')); ?>"></script>


    <!-- Date range use moment.js same as full calendar plugin -->
    <script src="<?php echo e(asset('assets/admin/js/plugins/fullcalendar/moment.min.js')); ?>"></script>

    <!-- Date range picker -->
    <script src="<?php echo e(asset('assets/admin/js/plugins/daterangepicker/daterangepicker.js')); ?>"></script>
    <link href="<?php echo e(asset('assets/admin/css/plugins/daterangepicker/daterangepicker-bs3.css')); ?>" rel="stylesheet">

    <script src="<?php echo e(asset('assets/common/js/jquery.ui.touch-punch.js')); ?>"></script>

    <style type="text/css">
        .hidden {
            display: none !important;
        }

        div.phpdebugbar-widgets-sqlqueries li.phpdebugbar-widgets-list-item.phpdebugbar-widgets-sql-duplicate {
            background-color: yellow !important;
        }

        .metismenu li, .metismenu hr {
            width: 100%;
        }

        .fr-box.fr-code-view textarea.fr-code {
            overflow: auto !important;
        }

        #ui-datepicker-div {
            z-index: 999 !important;
        }

        @media (max-width: 800px) {
            #page-wrapper {
                padding: 0;
            }

            .wrapper-content {
                padding-left: 0;
                padding-right: 0;
            }

            .page-heading {
                margin: 0;
            }

            #page-wrapper > .row.border-bottom {
                margin: 0;
            }

            .mobile-negative-margins {
                margin: 0 -20px;
                margin: 0 -30px;
            }

            @media (max-width: 767px) {
                .tabs-container .nav-tabs > li {
                    float: left !important;
                }
            }
        }

        .fr-wrapper img {
            height: auto;
            width: auto;
            max-width: 100%;
            margin-top: 0.5rem;
            margin-bottom: 2rem;
        }

        @media (min-width: 800px) {
            .fr-wrapper img {
                max-width: 400px;
            }
        }

        /*.fr-wrapper img.size-full, .fr-wrapper img.alignnone, .fr-wrapper img.size-medium {*/
        /*    display: block;*/
        /*}*/
    </style>
</head>

<body>
<div id="wrapper">
    <nav class="navbar-default navbar-static-side" role="navigation">
        <div class="sidebar-collapse">
            <ul class="nav metismenu" id="side-menu">
                <li class="nav-header">
                    <div class="dropdown profile-element"> <span>
                            <a href="<?php echo e(route('site.')); ?>">
                                    <img alt="image" class="img-rounded"
                                         src="<?php echo e(asset('assets/site/images/logo/logo.png')); ?>"
                                         style="object-fit: contain; height: 48px; max-width: 100%"/>
                                </a>
                                </span>
                        <a href="#">
                                    <span class="clear"> <span class="block m-t-xs"> <strong class="font-bold">Administrator</strong>
                                        </span>  </span> </a>

                    </div>
                    <div class="logo-element">
                        ADMIN
                    </div>
                </li>
                <li class="">
                    <a href="<?php echo e(route('admin.')); ?>"><i class="fa fa-home"></i> <span class="nav-label">Home</span></a>
                </li>
                <hr/>

                <li class="">
                    <a href="<?php echo e(route('admin.categories.index')); ?>"><i class="fa fa-list"></i> <span
                                class="nav-label">Categorii</span></a>
                </li>
                <hr/>

                <?php $__currentLoopData = \App\Model\Category::root()->where('id', '!=', config('categories_mapping.pages'))->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $current_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="">
                        <a
                                href="<?php echo e(route('admin.articles.index', $current_category->can_have_children ?  ['parent_id' => $current_category->id] : ['root_id' => $current_category->id, 'category_id' => $current_category->id])); ?>">
                            <i
                                    class="fa <?php echo e(!$current_category->isArticle() ? 'fa-cutlery' : 'fa-file'); ?>"></i> <span
                                    class="nav-label"><?php echo e($current_category->name); ?></span></a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                
                
                

                
                
                
                





                
                
                


                
                
                
                




                
                
                
                
                
                
                
                
                




                
                <hr/>
                <li class="">
                    <a href="<?php echo e(route('admin.reviews.index')); ?>"><i class="fa fa-comment"></i> <span class="nav-label">Comentarii</span>
                        <?php if($review_count): ?>
                            &nbsp;
                            <div class="badge badge-danger">
                                <?php echo e($review_count); ?>

                            </div>
                        <?php endif; ?>
                    </a>
                </li>

                <!--                                                <li class="">
                                                                    <a href="ss"><i class="fa fa-eur"></i> <span class="nav-label">Comenzi</span></a>
                                                                </li>-->
                
                
                
                
                
                

                <hr/>

            </ul>

        </div>
    </nav>

    <div id="page-wrapper" class="gray-bg dashbard-1">
        <div class="row border-bottom">
            <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
                <div class="navbar-header">
                    <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i>
                    </a>
                    <!--                            <form role="search" class="navbar-form-custom" action="search_results.html">
                                                    <div class="form-group">
                                                        <input type="text" placeholder="Search for something..." class="form-control" name="top-search" id="top-search">
                                                    </div>
                                                </form>-->
                </div>
                <ul class="nav navbar-top-links navbar-right">
                    <li>
                        <a href="/logout">
                            <i class="fa fa-sign-out"></i> Log out
                        </a>
                    </li>
                </ul>
            </nav>
        </div>

        <div class="row">
            <div class="col-lg-12">

                <?php if($review_count): ?>
                    <div class="alert-danger p-xs">
                        <a href="<?php echo e(route('admin.reviews.index')); ?>" class="btn btn-default btn-xs pull-right">vezi</a>
                        Sunt <b><?php echo e($review_count); ?></b> comentarii noi ce necesita aprobare.
                    </div>
                <?php endif; ?>
                <div class="row wrapper border-bottom white-bg page-heading">
                    <div class="col-lg-12">
                        <div class="pull-right">
                            <?php echo $__env->yieldContent('actions'); ?>
                        </div>
                        <h2><?php echo $__env->yieldContent('title'); ?></h2>
                        <ol class="breadcrumb">
                            <li>
                                <a href="/admin">Home</a>
                            </li>
                            <li class="active">
                                <strong><?php echo $__env->yieldContent('title'); ?></strong>
                            </li>
                        </ol>
                    </div>
                </div>

                <div class="wrapper wrapper-content animated-or-not fadeInRight-or-not">
                    <div class="row">
                        <div class="col-lg-12 m-b-lg">
                            <?php if(count($errors) > 0): ?>
                                <div class="alert alert-danger">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <p><?php echo e($error); ?></p>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>

                            <?php if(session('status')): ?>
                                <div class="alert alert-warning text-center" role="alert"><p><?php echo e(session('status')); ?></p>
                                </div>
                            <?php elseif(session('error')): ?>
                                <div class="alert alert-danger" role="alert"><h3><?php echo e(session('error')); ?></h3></div>
                            <?php endif; ?>

                            <?php echo $__env->yieldContent('content'); ?>
                        </div>
                    </div>
                </div>
                <div class="footer">
                    <div class="pull-right">
                        <strong></strong>
                    </div>
                    <div>
                        <strong>Copyright</strong> icetech &copy; <?php echo e(date('Y')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- GITTER -->
<script src="<?php echo e(asset('assets/admin/js/plugins/gritter/jquery.gritter.min.js')); ?>"></script>

<!-- Sparkline -->
<script src="<?php echo e(asset('assets/admin/js/plugins/sparkline/jquery.sparkline.min.js')); ?>"></script>

<!-- Sparkline demo data  -->
<script src="<?php echo e(asset('assets/admin/js/demo/sparkline-demo.js')); ?>"></script>

<!-- ChartJS-->
<script src="<?php echo e(asset('assets/admin/js/plugins/chartJs/Chart.min.js')); ?>"></script>

<!-- Toastr -->
<script src="<?php echo e(asset('assets/admin/js/plugins/toastr/toastr.min.js')); ?>"></script>

<!-- FooTable -->
<script src="<?php echo e(asset('assets/admin/js/plugins/footable/footable.all.min.js')); ?>"></script>


</body>
</html>
<?php /**PATH /home/superch1/public_html/resources/views/layouts/admin.blade.php ENDPATH**/ ?>