<?php /** @var \App\Model\Article $article */ ?>
<?php /** @var \App\Model\Article\ArticlePhoto $photo */ ?>


<?php $__env->startSection('title', $article->title); ?>
<?php $__env->startSection('url', url()->current()); ?>


<?php $__env->startSection('meta'); ?>
    <meta property="og:locale" content="ro_RO"/>
    <meta property="og:locale:alternate" content="ro_RO"/>
    <meta property="og:site_name" content="<?php echo e(config('app.name')); ?>"/>
    <meta property="og:title" content="<?php echo e($article->title); ?>"/>
    <meta property="og:url" content="<?php echo $__env->yieldContent('url'); ?>"/>
    <meta property="og:type" content="Article"/>
    <meta property="og:image" content="<?php echo e($article->getThumbUrl()); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<section class="post__details pt-4">
    <div class="container">
	<div class="row justify-content-center">
	    <div class="col-md-10 col-lg-8 mb-4">

		<div class="d-flex align-items-center mb-4 pb-4">
		    <a href="<?php echo e(route('site.articles.index')); ?>" class="me-3">
			<svg class="icon icon-md fill-black stroke-1 stroke-black circle-icon bg-gray-300"> <use xlink:href="#icon-arrow-left"></use> </svg>
		    </a>

		    <nav aria-label="breadcrumb" class="breadcrumb-holder">
			<ol class="breadcrumb mb-0 pe-3">
			   <li class="breadcrumb-item ">
				<a href="<?php echo e(route('site.')); ?>" class="line-height-20">
				    <svg class="icon icon-sm fill-black "> <use xlink:href="#icon-home"></use> </svg>
				</a>
			    </li>
			    <li class="breadcrumb-item"><a href="<?php echo e(route('site.articles.index')); ?>">Povești din bucătărie</a></li>
			    <li class="breadcrumb-item active" aria-current="page"><?php echo e($article->title); ?></li>
			</ol>
		    </nav>

		</div>


		<h1 class="fs-48 fw-700 fw-md-800 mb-2 ">
		    <?php echo e($article->title); ?>

		</h1>

		<div class="fs-14 fw-600">
		    <span>Postat de <?php echo e(config('app.name')); ?></span>   &sdot; <span><?php echo e($article->published_at->diffForHumans('')); ?></span>
		</div>
	    </div>

	    <div class="col-md-10 col-lg-8 col-xxl-10 mb-2">
		<div class="post__cover" style="background-image: url('<?php echo e($article->getPhotoUrl()); ?>')"> </div>
	    </div>

	    <div class="col-md-10 col-lg-8">
		<div class="fs-14 mb-4 mb-xl-5">Imagine: <a href="#" target="_blank" class="font-underline">Sursă foto</a></div>

		<div class="post__description">
		    <?php echo $article->body; ?>

		</div>
	    </div>
	</div>
    </div>
</section>

<section class="pt-0">
    <div class="container">
	<div class="row justify-content-center">
	    <div class="col-md-10 col-lg-8">
		<div class="fs-24 fw-700 mb-4">Articole similare</div>

		<?php if($articles->count()): ?>

                <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-3 g-xl-4">
                    <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		    <?php $__env->startComponent('site.article.item', compact('article')); ?> <?php if (isset($__componentOriginal024dc243ec09f2218f3b43b1c77d5b6fefff2dcc)): ?>
<?php $component = $__componentOriginal024dc243ec09f2218f3b43b1c77d5b6fefff2dcc; ?>
<?php unset($__componentOriginal024dc243ec09f2218f3b43b1c77d5b6fefff2dcc); ?>
<?php endif; ?>
<?php echo $__env->renderComponent(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

		<?php endif; ?>
	    </div>
	</div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/superch1/public_html/resources/views/site/article/show.blade.php ENDPATH**/ ?>